/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Arrays;
import org.neo4j.internal.batchimport.BatchingIdGetter;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.input.InputEntityVisitor;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.batchimport.store.BatchingTokenRepository;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.StandardDynamicRecordAllocator;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class EntityImporter
extends InputEntityVisitor.Adapter {
    private static final String ENTITY_IMPORTER_TAG = "entityImporter";
    private final BatchingTokenRepository.BatchingPropertyKeyTokenRepository propertyKeyTokenRepository;
    private final PropertyStore propertyStore;
    private final PropertyRecord propertyRecord;
    private final PageCursor propertyUpdateCursor;
    protected final StoreCursors storeCursors;
    private PropertyBlock[] propertyBlocks = new PropertyBlock[100];
    private int propertyBlocksCursor;
    private final BatchingIdGetter propertyIds;
    private final BatchingIdGetter stringPropertyIds;
    private final BatchingIdGetter arrayPropertyIds;
    protected final DataImporter.Monitor monitor;
    protected final MemoryTracker memoryTracker;
    private long propertyCount;
    protected int entityPropertyCount;
    private boolean hasPropertyId;
    private long propertyId;
    private final DynamicRecordAllocator dynamicStringRecordAllocator;
    private final DynamicRecordAllocator dynamicArrayRecordAllocator;
    protected final CursorContext cursorContext;

    EntityImporter(BatchingNeoStores stores, DataImporter.Monitor monitor, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.cursorContext = new CursorContext(pageCacheTracer.createPageCursorTracer(ENTITY_IMPORTER_TAG));
        this.storeCursors = new CachedStoreCursors(stores.getNeoStores(), this.cursorContext);
        this.propertyStore = stores.getPropertyStore();
        this.propertyKeyTokenRepository = stores.getPropertyKeyRepository();
        this.monitor = monitor;
        this.memoryTracker = memoryTracker;
        for (int i = 0; i < this.propertyBlocks.length; ++i) {
            this.propertyBlocks[i] = new PropertyBlock();
        }
        this.propertyRecord = this.propertyStore.newRecord();
        this.propertyIds = new BatchingIdGetter(this.propertyStore);
        this.stringPropertyIds = new BatchingIdGetter(this.propertyStore.getStringStore());
        this.dynamicStringRecordAllocator = new StandardDynamicRecordAllocator(this.stringPropertyIds, this.propertyStore.getStringStore().getRecordDataSize());
        this.arrayPropertyIds = new BatchingIdGetter(this.propertyStore.getArrayStore());
        this.dynamicArrayRecordAllocator = new StandardDynamicRecordAllocator(this.arrayPropertyIds, this.propertyStore.getStringStore().getRecordDataSize());
        this.propertyUpdateCursor = this.propertyStore.openPageCursorForWriting(0L, this.cursorContext);
    }

    public boolean property(String key, Object value) {
        assert (!this.hasPropertyId);
        return this.property(this.propertyKeyTokenRepository.getOrCreateId(key), value);
    }

    public boolean property(int propertyKeyId, Object value) {
        assert (!this.hasPropertyId);
        this.encodeProperty(this.nextPropertyBlock(), propertyKeyId, value);
        ++this.entityPropertyCount;
        return true;
    }

    public boolean propertyId(long nextProp) {
        assert (!this.hasPropertyId);
        this.hasPropertyId = true;
        this.propertyId = nextProp;
        return true;
    }

    public void endOfEntity() {
        this.propertyBlocksCursor = 0;
        this.hasPropertyId = false;
        this.propertyCount += (long)this.entityPropertyCount;
        this.entityPropertyCount = 0;
    }

    private PropertyBlock nextPropertyBlock() {
        if (this.propertyBlocksCursor == this.propertyBlocks.length) {
            this.propertyBlocks = Arrays.copyOf(this.propertyBlocks, this.propertyBlocksCursor * 2);
            for (int i = this.propertyBlocksCursor; i < this.propertyBlocks.length; ++i) {
                this.propertyBlocks[i] = new PropertyBlock();
            }
        }
        return this.propertyBlocks[this.propertyBlocksCursor++];
    }

    private void encodeProperty(PropertyBlock block, int key, Object property) {
        Value value = property instanceof Value ? (Value)property : Values.of((Object)property);
        PropertyStore.encodeValue(block, key, value, this.dynamicStringRecordAllocator, this.dynamicArrayRecordAllocator, this.propertyStore.allowStorePointsAndTemporal(), this.cursorContext, this.memoryTracker);
    }

    long createAndWritePropertyChain(CursorContext cursorContext) {
        if (this.hasPropertyId) {
            return this.propertyId;
        }
        if (this.propertyBlocksCursor == 0) {
            return Record.NO_NEXT_PROPERTY.longValue();
        }
        PropertyRecord currentRecord = this.propertyRecord(this.propertyIds.nextId(cursorContext));
        long firstRecordId = currentRecord.getId();
        for (int i = 0; i < this.propertyBlocksCursor; ++i) {
            PropertyBlock block = this.propertyBlocks[i];
            if (currentRecord.size() + block.getSize() > PropertyType.getPayloadSize()) {
                long nextPropertyId = this.propertyIds.nextId(cursorContext);
                long prevId = currentRecord.getId();
                currentRecord.setNextProp(nextPropertyId);
                this.propertyStore.updateRecord(currentRecord, IdUpdateListener.IGNORE, this.propertyUpdateCursor, cursorContext, this.storeCursors);
                currentRecord = this.propertyRecord(nextPropertyId);
                currentRecord.setPrevProp(prevId);
            }
            currentRecord.addPropertyBlock(block);
        }
        if (currentRecord.size() > 0) {
            this.propertyStore.updateRecord(currentRecord, IdUpdateListener.IGNORE, this.propertyUpdateCursor, cursorContext, this.storeCursors);
        }
        return firstRecordId;
    }

    protected abstract PrimitiveRecord primitiveRecord();

    private PropertyRecord propertyRecord(long nextPropertyId) {
        this.propertyRecord.clear();
        this.propertyRecord.setInUse(true);
        this.propertyRecord.setId(nextPropertyId);
        this.primitiveRecord().setIdTo(this.propertyRecord);
        this.propertyRecord.setCreated();
        return this.propertyRecord;
    }

    public void close() {
        this.monitor.propertiesImported(this.propertyCount);
        this.propertyUpdateCursor.close();
    }

    void freeUnusedIds() {
        EntityImporter.freeUnusedIds(this.propertyStore, this.propertyIds, this.cursorContext);
        EntityImporter.freeUnusedIds(this.propertyStore.getStringStore(), this.stringPropertyIds, this.cursorContext);
        EntityImporter.freeUnusedIds(this.propertyStore.getArrayStore(), this.arrayPropertyIds, this.cursorContext);
    }

    static void freeUnusedIds(CommonAbstractStore<?, ?> store, BatchingIdGetter idBatch, CursorContext cursorContext) {
        try (IdGenerator.Marker marker = store.getIdGenerator().marker(cursorContext);){
            idBatch.visitUnused(arg_0 -> ((IdGenerator.Marker)marker).markDeleted(arg_0));
        }
    }
}

