/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.common.ProgressReporter;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.LabelIndexWriterStep;
import org.neo4j.internal.batchimport.MemoryUsageStatsProvider;
import org.neo4j.internal.batchimport.NodeCountsProcessor;
import org.neo4j.internal.batchimport.RecordIdIterators;
import org.neo4j.internal.batchimport.RecordProcessorStep;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeCountsAndLabelIndexBuildStage
extends Stage {
    public static final String NAME = "Node counts and label index build";

    public NodeCountsAndLabelIndexBuildStage(Configuration config, BatchingNeoStores neoStores, NodeLabelsCache cache, NodeStore nodeStore, int highLabelId, CountsAccessor.Updater countsUpdater, ProgressReporter progressReporter, IndexImporterFactory indexImporterFactory, PageCacheTracer pageCacheTracer, Function<CursorContext, StoreCursors> storeCursorsCreator, MemoryTracker memoryTracker, MemoryUsageStatsProvider additionalStatsProviders) {
        super(NAME, null, config, 3);
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterators.allIn(nodeStore, config), nodeStore.getRecordSize()));
        this.add((Step)new ReadRecordsStep<NodeRecord>(this.control(), config, false, nodeStore, pageCacheTracer));
        if (config.indexConfig().createLabelIndex()) {
            this.add((Step)new LabelIndexWriterStep(this.control(), config, neoStores, indexImporterFactory, memoryTracker, pageCacheTracer, storeCursorsCreator));
        }
        this.add((Step)new RecordProcessorStep(this.control(), "COUNT", config, () -> new NodeCountsProcessor(nodeStore, cache, highLabelId, countsUpdater, progressReporter), true, 0, pageCacheTracer, storeCursorsCreator, new StatsProvider[]{additionalStatsProviders}));
    }
}

