/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import org.neo4j.common.DependencyResolver;
import org.neo4j.internal.batchimport.DataStatistics;
import org.neo4j.internal.batchimport.ImportMemoryCalculator;
import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NodeRelationshipCache;
import org.neo4j.internal.batchimport.cache.PageCacheArrayFactoryMonitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.StageExecution;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.ByteUnit;

public class HumanUnderstandableExecutionMonitor
implements ExecutionMonitor {
    public static final Monitor NO_MONITOR = (stage, percent) -> {};
    private static final String ESTIMATED_REQUIRED_MEMORY_USAGE = "Estimated required memory usage";
    private static final String ESTIMATED_DISK_SPACE_USAGE = "Estimated disk space usage";
    private static final String ESTIMATED_NUMBER_OF_RELATIONSHIP_PROPERTIES = "Estimated number of relationship properties";
    private static final String ESTIMATED_NUMBER_OF_RELATIONSHIPS = "Estimated number of relationships";
    private static final String ESTIMATED_NUMBER_OF_NODE_PROPERTIES = "Estimated number of node properties";
    private static final String ESTIMATED_NUMBER_OF_NODES = "Estimated number of nodes";
    private static final int DOT_GROUP_SIZE = 10;
    private static final int DOT_GROUPS_PER_LINE = 5;
    private static final int PERCENTAGES_PER_LINE = 5;
    private final Monitor monitor;
    private DependencyResolver dependencyResolver;
    private boolean newInternalStage;
    private PageCacheArrayFactoryMonitor pageCacheArrayFactoryMonitor;
    private long goal;
    private long stashedProgress;
    private long progress;
    private ImportStage currentStage;
    private long lastReportTime;
    private long stageStartTime;

    HumanUnderstandableExecutionMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void initialize(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
        Input.Estimates estimates = (Input.Estimates)dependencyResolver.resolveDependency(Input.Estimates.class);
        BatchingNeoStores neoStores = (BatchingNeoStores)dependencyResolver.resolveDependency(BatchingNeoStores.class);
        IdMapper idMapper = (IdMapper)dependencyResolver.resolveDependency(IdMapper.class);
        this.pageCacheArrayFactoryMonitor = (PageCacheArrayFactoryMonitor)dependencyResolver.resolveDependency(PageCacheArrayFactoryMonitor.class);
        long biggestCacheMemory = ImportMemoryCalculator.estimatedCacheSize(neoStores, NodeRelationshipCache.memoryEstimation((long)estimates.numberOfNodes()), idMapper.memoryEstimation(estimates.numberOfNodes()));
        System.out.println();
        HumanUnderstandableExecutionMonitor.printStageHeader("Import starting", ESTIMATED_NUMBER_OF_NODES, Format.count((long)estimates.numberOfNodes()), ESTIMATED_NUMBER_OF_NODE_PROPERTIES, Format.count((long)estimates.numberOfNodeProperties()), ESTIMATED_NUMBER_OF_RELATIONSHIPS, Format.count((long)estimates.numberOfRelationships()), ESTIMATED_NUMBER_OF_RELATIONSHIP_PROPERTIES, Format.count((long)estimates.numberOfRelationshipProperties()), ESTIMATED_DISK_SPACE_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.nodesDiskUsage(estimates, neoStores) + HumanUnderstandableExecutionMonitor.relationshipsDiskUsage(estimates, neoStores) + estimates.sizeOfNodeProperties() + estimates.sizeOfRelationshipProperties())), ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)biggestCacheMemory));
        System.out.println();
    }

    private static long baselineMemoryRequirement(BatchingNeoStores neoStores) {
        return GatheringMemoryStatsVisitor.totalMemoryUsageOf((MemoryStatsVisitor.Visitable[])new MemoryStatsVisitor.Visitable[]{neoStores});
    }

    private static long nodesDiskUsage(Input.Estimates estimates, BatchingNeoStores neoStores) {
        return estimates.numberOfNodes() * (long)neoStores.getNodeStore().getRecordSize() + estimates.numberOfNodeLabels();
    }

    private static long relationshipsDiskUsage(Input.Estimates estimates, BatchingNeoStores neoStores) {
        return estimates.numberOfRelationships() * (long)neoStores.getRelationshipStore().getRecordSize() * (long)(neoStores.usesDoubleRelationshipRecordUnits() ? 2 : 1);
    }

    public void start(StageExecution execution) {
        if (execution.getStageName().equals("Nodes")) {
            this.initializeNodeImport((Input.Estimates)this.dependencyResolver.resolveDependency(Input.Estimates.class), (IdMapper)this.dependencyResolver.resolveDependency(IdMapper.class), (BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class));
        } else if (execution.getStageName().equals("Relationships")) {
            this.endPrevious();
            this.initializeRelationshipImport((Input.Estimates)this.dependencyResolver.resolveDependency(Input.Estimates.class), (IdMapper)this.dependencyResolver.resolveDependency(IdMapper.class), (BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class));
        } else if (execution.getStageName().equals("Node Degrees")) {
            this.endPrevious();
            this.initializeLinking((BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class), (DataStatistics)this.dependencyResolver.resolveDependency(DataStatistics.class));
        } else if (execution.getStageName().equals("Count groups")) {
            this.endPrevious();
            this.initializeMisc((BatchingNeoStores)this.dependencyResolver.resolveDependency(BatchingNeoStores.class), (DataStatistics)this.dependencyResolver.resolveDependency(DataStatistics.class));
        } else if (HumanUnderstandableExecutionMonitor.includeStage(execution)) {
            this.stashedProgress += this.progress;
            this.progress = 0L;
            this.newInternalStage = true;
        }
        this.lastReportTime = System.currentTimeMillis();
    }

    private void endPrevious() {
        this.updateProgress(this.goal);
        if (this.currentStage != null) {
            System.out.printf("%s COMPLETED in %s%n%n", this.currentStage.description(), Format.duration((long)(System.currentTimeMillis() - this.stageStartTime)));
        }
    }

    private void initializeNodeImport(Input.Estimates estimates, IdMapper idMapper, BatchingNeoStores neoStores) {
        long numberOfNodes = estimates.numberOfNodes();
        this.startStage(ImportStage.nodeImport, ESTIMATED_NUMBER_OF_NODES, Format.count((long)numberOfNodes), ESTIMATED_DISK_SPACE_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.nodesDiskUsage(estimates, neoStores) + estimates.sizeOfNodeProperties())), ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + ImportMemoryCalculator.defensivelyPadMemoryEstimate(idMapper.memoryEstimation(numberOfNodes)))));
        long goal = idMapper.needsPreparation() ? numberOfNodes + HumanUnderstandableExecutionMonitor.weighted("Prepare node index", numberOfNodes * 4L) : numberOfNodes;
        this.initializeProgress(goal, ImportStage.nodeImport);
    }

    private void initializeRelationshipImport(Input.Estimates estimates, IdMapper idMapper, BatchingNeoStores neoStores) {
        long numberOfRelationships = estimates.numberOfRelationships();
        this.startStage(ImportStage.relationshipImport, ESTIMATED_NUMBER_OF_RELATIONSHIPS, Format.count((long)numberOfRelationships), ESTIMATED_DISK_SPACE_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.relationshipsDiskUsage(estimates, neoStores) + estimates.sizeOfRelationshipProperties())), ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + GatheringMemoryStatsVisitor.totalMemoryUsageOf((MemoryStatsVisitor.Visitable[])new MemoryStatsVisitor.Visitable[]{idMapper}))));
        this.initializeProgress(numberOfRelationships, ImportStage.relationshipImport);
    }

    private void initializeLinking(BatchingNeoStores neoStores, DataStatistics distribution) {
        this.startStage(ImportStage.linking, ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)(HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores) + ImportMemoryCalculator.defensivelyPadMemoryEstimate(NodeRelationshipCache.memoryEstimation((long)distribution.getNodeCount())))));
        long relationshipRecordIdCount = neoStores.getRelationshipStore().getHighId();
        long actualRelationshipCount = distribution.getRelationshipCount();
        this.initializeProgress(relationshipRecordIdCount + actualRelationshipCount * 2L + actualRelationshipCount * 2L, ImportStage.linking);
    }

    private void initializeMisc(BatchingNeoStores neoStores, DataStatistics distribution) {
        this.startStage(ImportStage.postProcessing, ESTIMATED_REQUIRED_MEMORY_USAGE, ByteUnit.bytesToString((long)HumanUnderstandableExecutionMonitor.baselineMemoryRequirement(neoStores)));
        long actualNodeCount = distribution.getNodeCount();
        long relationshipRecordIdCount = neoStores.getRelationshipStore().getHighId();
        long groupCount = neoStores.getTemporaryRelationshipGroupStore().getHighId();
        this.initializeProgress(groupCount + groupCount + groupCount + actualNodeCount + relationshipRecordIdCount, ImportStage.postProcessing);
    }

    private void initializeProgress(long goal, ImportStage stage) {
        this.goal = goal;
        this.stashedProgress = 0L;
        this.progress = 0L;
        this.currentStage = stage;
        this.newInternalStage = false;
    }

    private void updateProgress(long progress) {
        int maxDot = this.dotOf(this.goal);
        int currentProgressDot = this.dotOf(this.stashedProgress + this.progress);
        int currentLine = currentProgressDot / HumanUnderstandableExecutionMonitor.dotsPerLine();
        int currentDotOnLine = currentProgressDot % HumanUnderstandableExecutionMonitor.dotsPerLine();
        int progressDot = Integer.min(maxDot, this.dotOf(this.stashedProgress + progress));
        int line = progressDot / HumanUnderstandableExecutionMonitor.dotsPerLine();
        int dotOnLine = progressDot % HumanUnderstandableExecutionMonitor.dotsPerLine();
        while (currentLine < line || currentLine == line && currentDotOnLine < dotOnLine) {
            int target = currentLine < line ? HumanUnderstandableExecutionMonitor.dotsPerLine() : dotOnLine;
            this.printDots(currentDotOnLine, target);
            currentDotOnLine = target;
            if (currentLine >= line && currentDotOnLine != HumanUnderstandableExecutionMonitor.dotsPerLine()) continue;
            int percentage = HumanUnderstandableExecutionMonitor.percentage(currentLine);
            System.out.printf("%4d%% \u2206%s%n", percentage, this.durationSinceLastReport());
            this.monitor.progress(this.currentStage, percentage);
            if (++currentLine == HumanUnderstandableExecutionMonitor.lines()) {
                System.out.println();
            }
            currentDotOnLine = 0;
        }
        this.progress = Long.max(this.progress, progress);
    }

    private String durationSinceLastReport() {
        long diff = System.currentTimeMillis() - this.lastReportTime;
        this.lastReportTime = System.currentTimeMillis();
        return Format.duration((long)diff);
    }

    private static int percentage(int line) {
        return (line + 1) * 5;
    }

    private void printDots(int from, int target) {
        for (int current = from; current < target; ++current) {
            if (current > 0 && current % 10 == 0) {
                System.out.print(' ');
            }
            int dotChar = 46;
            if (this.newInternalStage) {
                this.newInternalStage = false;
                dotChar = 45;
            }
            System.out.print((char)dotChar);
            this.printPageCacheAllocationWarningIfUsed();
        }
    }

    private void printPageCacheAllocationWarningIfUsed() {
        String allocation = this.pageCacheArrayFactoryMonitor.pageCacheAllocationOrNull();
        if (allocation != null) {
            System.err.println();
            System.err.println("WARNING:");
            System.err.println(allocation);
        }
    }

    private int dotOf(long progress) {
        int dots = HumanUnderstandableExecutionMonitor.dotsPerLine() * HumanUnderstandableExecutionMonitor.lines();
        if (progress == this.goal) {
            return dots;
        }
        double dotSize = (double)this.goal / (double)dots;
        return (int)((double)progress / dotSize);
    }

    private static int lines() {
        return 20;
    }

    private static int dotsPerLine() {
        return 50;
    }

    private void startStage(ImportStage stage, Object ... data) {
        HumanUnderstandableExecutionMonitor.printStageHeader(stage.descriptionWithOrdinal(), data);
        this.stageStartTime = System.currentTimeMillis();
        this.currentStage = stage;
    }

    private static void printStageHeader(String description, Object ... data) {
        System.out.println(description + " " + Format.localDate());
        if (data.length > 0) {
            int i = 0;
            while (i < data.length) {
                System.out.println("  " + data[i++] + ": " + data[i++]);
            }
        }
    }

    public void end(StageExecution execution, long totalTimeMillis) {
    }

    public void done(boolean successful, long totalTimeMillis, String additionalInformation) {
        this.endPrevious();
        System.out.println();
        System.out.printf("IMPORT %s in %s. %s%n", successful ? "DONE" : "FAILED", Format.duration((long)totalTimeMillis), additionalInformation);
    }

    public long nextCheckTime() {
        return System.currentTimeMillis() + 200L;
    }

    public void check(StageExecution execution) {
        if (HumanUnderstandableExecutionMonitor.includeStage(execution)) {
            this.updateProgress(HumanUnderstandableExecutionMonitor.progressOf(execution));
        }
    }

    private static boolean includeStage(StageExecution execution) {
        String name = execution.getStageName();
        return !name.equals("RelationshipGroup") && !name.equals("Node --> Relationship") && !name.equals("Gather");
    }

    private static double weightOf(String stageName) {
        if (stageName.equals("Prepare node index")) {
            return 0.5;
        }
        return 1.0;
    }

    private static long weighted(String stageName, long progress) {
        return (long)((double)progress * HumanUnderstandableExecutionMonitor.weightOf(stageName));
    }

    private static long progressOf(StageExecution execution) {
        Stat progressStat = HumanUnderstandableExecutionMonitor.findProgressStat(execution.steps());
        if (progressStat != null) {
            return HumanUnderstandableExecutionMonitor.weighted(execution.getStageName(), progressStat.asLong());
        }
        long doneBatches = ((Step)Iterables.last((Iterable)execution.steps())).stats().stat((Key)Keys.done_batches).asLong();
        int batchSize = execution.getConfig().batchSize();
        return HumanUnderstandableExecutionMonitor.weighted(execution.getStageName(), doneBatches * (long)batchSize);
    }

    private static Stat findProgressStat(Iterable<Step<?>> steps) {
        for (Step<?> step : steps) {
            Stat stat = step.stats().stat((Key)Keys.progress);
            if (stat == null) continue;
            return stat;
        }
        return null;
    }

    static enum ImportStage {
        nodeImport("Node import"),
        relationshipImport("Relationship import"),
        linking("Relationship linking"),
        postProcessing("Post processing");

        private final String description;

        private ImportStage(String description) {
            this.description = description;
        }

        String descriptionWithOrdinal() {
            return String.format("(%d/%d) %s", this.ordinal() + 1, ImportStage.values().length, this.description);
        }

        String description() {
            return this.description;
        }
    }

    public static interface Monitor {
        public void progress(ImportStage var1, int var2);
    }
}

