/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.store;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public abstract class BatchingTokenRepository<RECORD extends TokenRecord>
implements ToIntFunction<Object> {
    private final Map<String, TokenId> tokens = new HashMap<String, TokenId>();
    private final TokenStore<RECORD> store;
    private final IntFunction<RECORD> recordInstantiator;
    private int highId;
    private int highestCreatedId;

    BatchingTokenRepository(TokenStore<RECORD> store, IntFunction<RECORD> recordInstantiator) {
        this.store = store;
        this.recordInstantiator = recordInstantiator;
        this.highId = (int)store.getHighId();
        this.highestCreatedId = this.highId - 1;
    }

    public int getOrCreateId(String name) {
        return this.getOrCreateId(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateId(String name, boolean internal) {
        try {
            TokenWrite.checkValidTokenName((String)name);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        TokenId id = this.tokens.get(name);
        if (id == null) {
            Map<String, TokenId> map = this.tokens;
            synchronized (map) {
                id = this.tokens.computeIfAbsent(name, k -> new TokenId(this.highId++, internal));
            }
        }
        return id.value;
    }

    public int getOrCreateId(Object key) {
        if (key instanceof String) {
            return this.getOrCreateId((String)key);
        }
        if (key instanceof Integer) {
            return (Integer)key;
        }
        throw new IllegalArgumentException("Expected either a String or Integer for property key, but was '" + key + "', " + key.getClass());
    }

    @Override
    public int applyAsInt(Object key) {
        return this.getOrCreateId(key);
    }

    public long[] getOrCreateIds(String[] names) {
        return this.getOrCreateIds(names, names.length);
    }

    public long[] getOrCreateIds(String[] names, int length) {
        int from;
        long[] result = new long[length];
        int to = 0;
        for (from = 0; from < length; ++from) {
            int id = this.getOrCreateId(names[from]);
            if (BatchingTokenRepository.contains(result, id, to)) continue;
            result[to++] = id;
        }
        if (to < from) {
            result = Arrays.copyOf(result, to);
        }
        Arrays.sort(result);
        return result;
    }

    private static boolean contains(long[] array, long id, int arrayLength) {
        for (int i = 0; i < arrayLength; ++i) {
            if (array[i] != id) continue;
            return true;
        }
        return false;
    }

    public int getHighId() {
        return this.highId;
    }

    public void flush(CursorContext cursorContext, PageCursor pageCursor, StoreCursors storeCursors) {
        int highest = this.highestCreatedId;
        for (Map.Entry<TokenId, String> tokenToCreate : BatchingTokenRepository.sortCreatedTokensById(this.tokens)) {
            if (tokenToCreate.getKey().value <= this.highestCreatedId) continue;
            this.createToken(tokenToCreate.getValue(), tokenToCreate.getKey().value, tokenToCreate.getKey().internal, cursorContext, pageCursor, storeCursors);
            highest = Math.max(highest, tokenToCreate.getKey().value);
        }
        int highestId = Math.max(Math.toIntExact(this.store.getHighestPossibleIdInUse(cursorContext)), highest);
        this.store.setHighestPossibleIdInUse(highestId);
        this.highestCreatedId = highestId;
    }

    private void createToken(String name, int tokenId, boolean internal, CursorContext cursorContext, PageCursor pageCursor, StoreCursors storeCursors) {
        TokenRecord record = (TokenRecord)this.recordInstantiator.apply(tokenId);
        record.setInUse(true);
        record.setCreated();
        record.setInternal(internal);
        Collection<DynamicRecord> nameRecords = this.store.allocateNameRecords(PropertyStore.encodeString(name), cursorContext, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        record.setNameId((int)((DynamicRecord)Iterables.first(nameRecords)).getId());
        record.addNameRecords(nameRecords);
        this.store.updateRecord(record, pageCursor, cursorContext, storeCursors);
        try (PageCursor namedCursor = this.store.getWriteDynamicTokenCursor(storeCursors);){
            DynamicStringStore tokenNameStore = this.store.getNameStore();
            nameRecords.forEach(nameRecord -> tokenNameStore.updateRecord(nameRecord, namedCursor, cursorContext, storeCursors));
        }
    }

    private static Iterable<Map.Entry<TokenId, String>> sortCreatedTokensById(Map<String, TokenId> tokens) {
        TreeMap<TokenId, String> sorted = new TreeMap<TokenId, String>();
        for (Map.Entry<String, TokenId> entry : tokens.entrySet()) {
            sorted.put(entry.getValue(), entry.getKey());
        }
        return sorted.entrySet();
    }

    private static class TokenId
    implements Comparable<TokenId> {
        private final Integer value;
        private final boolean internal;

        TokenId(int value, boolean internal) {
            this.value = value;
            this.internal = internal;
        }

        @Override
        public int compareTo(TokenId other) {
            return this.value.compareTo(other.value);
        }
    }

    public static class BatchingRelationshipTypeTokenRepository
    extends BatchingTokenRepository<RelationshipTypeTokenRecord> {
        BatchingRelationshipTypeTokenRepository(TokenStore<RelationshipTypeTokenRecord> store) {
            super(store, RelationshipTypeTokenRecord::new);
        }
    }

    public static class BatchingLabelTokenRepository
    extends BatchingTokenRepository<LabelTokenRecord> {
        BatchingLabelTokenRepository(TokenStore<LabelTokenRecord> store) {
            super(store, LabelTokenRecord::new);
        }
    }

    public static class BatchingPropertyKeyTokenRepository
    extends BatchingTokenRepository<PropertyKeyTokenRecord> {
        BatchingPropertyKeyTokenRepository(TokenStore<PropertyKeyTokenRecord> store) {
            super(store, PropertyKeyTokenRecord::new);
        }
    }
}

