/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStore;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.storageengine.api.CommandsToApply;

class CountsStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final CountsStore countsStore;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final CommandsToApply transaction;
    private CountsAccessor.Updater countsUpdater;
    private RelationshipGroupDegreesStore.Updater degreesUpdater;
    private boolean haveUpdates;
    private boolean countsUpdaterClosed;
    private boolean degreesUpdaterClosed;

    CountsStoreTransactionApplier(CountsStore countsStore, RelationshipGroupDegreesStore groupDegreesStore, CommandsToApply transaction) {
        this.countsStore = countsStore;
        this.groupDegreesStore = groupDegreesStore;
        this.transaction = transaction;
    }

    @Override
    public void close() {
        this.closeCountsUpdatersIfOpen();
    }

    private void closeCountsUpdatersIfOpen() {
        if (!this.countsUpdaterClosed) {
            this.countsUpdater().close();
            this.countsUpdaterClosed = true;
        }
        if (!this.degreesUpdaterClosed) {
            this.degreesUpdater().close();
            this.degreesUpdaterClosed = true;
        }
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater().incrementNodeCount((long)command.labelId(), command.delta());
        return false;
    }

    private CountsAccessor.Updater countsUpdater() {
        if (this.countsUpdater == null) {
            this.countsUpdater = this.countsStore.apply(this.transaction.transactionId(), this.transaction.cursorContext());
        }
        return this.countsUpdater;
    }

    private RelationshipGroupDegreesStore.Updater degreesUpdater() {
        if (this.degreesUpdater == null) {
            this.degreesUpdater = this.groupDegreesStore.apply(this.transaction.transactionId(), this.transaction.cursorContext());
        }
        return this.degreesUpdater;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater().incrementRelationshipCount((long)command.startLabelId(), command.typeId(), (long)command.endLabelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        assert (!this.haveUpdates) : "Assumed that a schema transaction wouldn't also contain data commands affecting counts store, but was proven wrong with this transaction";
        this.closeCountsUpdatersIfOpen();
        return false;
    }

    @Override
    public boolean visitGroupDegreeCommand(Command.GroupDegreeCommand command) {
        this.haveUpdates = true;
        this.degreesUpdater().increment(command.groupId(), command.direction(), command.delta());
        return false;
    }
}

