/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.storageengine.api.LogVersionRepository;

public class ReadOnlyLogVersionRepository
implements LogVersionRepository {
    private static final int NOT_EXISTING_VERSION = 0;
    private final FixedLogVersion logVersion;
    private final FixedLogVersion checkpointLogVersion;

    public ReadOnlyLogVersionRepository(PageCache pageCache, DatabaseLayout databaseLayout, CursorContext cursorContext) throws IOException {
        this.logVersion = new FixedLogVersion(ReadOnlyLogVersionRepository.readLogVersion(pageCache, databaseLayout.metadataStore(), cursorContext, MetaDataStore.Position.LOG_VERSION, databaseLayout.getDatabaseName()));
        this.checkpointLogVersion = new FixedLogVersion(ReadOnlyLogVersionRepository.readLogVersion(pageCache, databaseLayout.metadataStore(), cursorContext, MetaDataStore.Position.CHECKPOINT_LOG_VERSION, databaseLayout.getDatabaseName()));
    }

    public long getCurrentLogVersion() {
        return ReadOnlyLogVersionRepository.getCurrentVersion(this.logVersion);
    }

    public void setCurrentLogVersion(long version, CursorContext cursorContext) {
        ReadOnlyLogVersionRepository.setCurrentVersionAttempt();
    }

    public long incrementAndGetVersion(CursorContext cursorContext) {
        return ReadOnlyLogVersionRepository.incrementAndGetVersion(this.logVersion);
    }

    public long getCheckpointLogVersion() {
        return ReadOnlyLogVersionRepository.getCurrentVersion(this.checkpointLogVersion);
    }

    public void setCheckpointLogVersion(long version, CursorContext cursorContext) {
        ReadOnlyLogVersionRepository.setCurrentVersionAttempt();
    }

    public long incrementAndGetCheckpointLogVersion(CursorContext cursorContext) {
        return ReadOnlyLogVersionRepository.incrementAndGetVersion(this.checkpointLogVersion);
    }

    private static long getCurrentVersion(FixedLogVersion version) {
        if (version.isIncrementAttempted()) {
            throw new IllegalStateException("Read-only log version repository has observed a call to incrementVersion, which indicates that it's been shut down");
        }
        return version.getValue();
    }

    private static void setCurrentVersionAttempt() {
        throw new UnsupportedOperationException("Can't set current log version in read only version repository.");
    }

    private static long incrementAndGetVersion(FixedLogVersion version) {
        if (version.isIncrementAttempted()) {
            throw new IllegalStateException("Read-only log version repository only allows to call incrementVersion once, during shutdown");
        }
        version.setIncrementAttempt();
        return version.getValue();
    }

    private static long readLogVersion(PageCache pageCache, Path neoStore, CursorContext cursorContext, MetaDataStore.Position position, String databaseName) throws IOException {
        try {
            long logVersion = MetaDataStore.getRecord(pageCache, neoStore, position, databaseName, cursorContext);
            return logVersion != -1L ? logVersion : 0L;
        }
        catch (NoSuchFileException ignore) {
            return 0L;
        }
    }

    private static class FixedLogVersion {
        private boolean incrementAttempt;
        private final long value;

        FixedLogVersion(long value) {
            this.value = value;
        }

        boolean isIncrementAttempted() {
            return this.incrementAttempt;
        }

        long getValue() {
            return this.value;
        }

        void setIncrementAttempt() {
            this.incrementAttempt = true;
        }
    }
}

