/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.util.LocalIntCounter;

public class RecordChanges<RECORD extends AbstractBaseRecord, ADDITIONAL>
implements RecordAccess<RECORD, ADDITIONAL> {
    private final MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> recordChanges;
    private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
    private final MutableInt changeCounter;
    private final RecordAccess.LoadMonitor loadMonitor;
    private final StoreCursors storeCursors;

    public RecordChanges(RecordAccess.Loader<RECORD, ADDITIONAL> loader, MutableInt globalCounter, MemoryTracker memoryTracker, RecordAccess.LoadMonitor loadMonitor, StoreCursors storeCursors) {
        this.loader = loader;
        this.recordChanges = HeapTrackingCollections.newLongObjectMap((MemoryTracker)memoryTracker);
        this.changeCounter = new LocalIntCounter(globalCounter);
        this.loadMonitor = loadMonitor;
        this.storeCursors = storeCursors;
    }

    public String toString() {
        return "RecordChanges{recordChanges=" + this.recordChanges + "}";
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getIfLoaded(long key) {
        return (RecordAccess.RecordProxy)this.recordChanges.get(key);
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> getOrLoad(long key, ADDITIONAL additionalData, RecordLoad load) {
        RecordChange<RECORD, ADDITIONAL> result = (RecordChange<RECORD, ADDITIONAL>)this.recordChanges.get(key);
        if (result == null) {
            RECORD record = this.loader.load(key, additionalData, load);
            result = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, false, additionalData, this.loadMonitor, this.storeCursors);
        }
        return result;
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> setRecord(long key, RECORD record, ADDITIONAL additionalData, CursorContext cursorContext) {
        RecordChange<RECORD, ADDITIONAL> recordChange = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, false, additionalData, this.loadMonitor, this.storeCursors);
        this.recordChanges.put(key, recordChange);
        return recordChange;
    }

    @Override
    public int changeSize() {
        return this.changeCounter.intValue();
    }

    @Override
    public RecordAccess.RecordProxy<RECORD, ADDITIONAL> create(long key, ADDITIONAL additionalData, CursorContext cursorContext) {
        if (this.recordChanges.containsKey(key)) {
            throw new IllegalStateException(key + " already exists");
        }
        RECORD record = this.loader.newUnused(key, additionalData);
        RecordChange<RECORD, ADDITIONAL> change = new RecordChange<RECORD, ADDITIONAL>(this.recordChanges, this.changeCounter, key, record, this.loader, true, additionalData, this.loadMonitor, this.storeCursors);
        this.recordChanges.put(key, change);
        return change;
    }

    @Override
    public Collection<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> changes() {
        return this.recordChanges.values();
    }

    public static class RecordChange<RECORD extends AbstractBaseRecord, ADDITIONAL>
    implements RecordAccess.RecordProxy<RECORD, ADDITIONAL> {
        private final MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> allChanges;
        private final MutableInt changeCounter;
        private final RecordAccess.Loader<RECORD, ADDITIONAL> loader;
        private final ADDITIONAL additionalData;
        private final RecordAccess.LoadMonitor loadMonitor;
        private final StoreCursors storeCursors;
        private final RECORD record;
        private final boolean created;
        private final long key;
        private RECORD before;
        private boolean changed;

        public RecordChange(MutableLongObjectMap<RecordAccess.RecordProxy<RECORD, ADDITIONAL>> allChanges, MutableInt changeCounter, long key, RECORD record, RecordAccess.Loader<RECORD, ADDITIONAL> loader, boolean created, ADDITIONAL additionalData, RecordAccess.LoadMonitor loadMonitor, StoreCursors storeCursors) {
            this.allChanges = allChanges;
            this.changeCounter = changeCounter;
            this.key = key;
            this.record = record;
            this.loader = loader;
            this.created = created;
            this.additionalData = additionalData;
            this.loadMonitor = loadMonitor;
            this.storeCursors = storeCursors;
        }

        public String toString() {
            return "RecordChange{record=" + this.record + ",key=" + this.key + ",created=" + this.created + "}";
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        public RECORD forChangingLinkage() {
            return this.prepareForChange();
        }

        @Override
        public RECORD forChangingData() {
            this.ensureHeavy(this.storeCursors);
            return this.prepareForChange();
        }

        private RECORD prepareForChange() {
            this.ensureHasBeforeRecordImage();
            if (!this.changed) {
                RecordAccess.RecordProxy previous = (RecordAccess.RecordProxy)this.allChanges.put(this.key, (Object)this);
                if (previous == null || !previous.isChanged()) {
                    this.loadMonitor.markedAsChanged((AbstractBaseRecord)this.before);
                    this.changeCounter.increment();
                }
                this.changed = true;
            }
            return this.record;
        }

        private void ensureHeavy(StoreCursors storeCursors) {
            if (!this.created) {
                this.loader.ensureHeavy(this.record, storeCursors);
                if (this.before != null) {
                    this.loader.ensureHeavy(this.before, storeCursors);
                }
            }
        }

        @Override
        public RECORD forReadingLinkage() {
            return this.record;
        }

        @Override
        public RECORD forReadingData() {
            this.ensureHeavy(this.storeCursors);
            return this.record;
        }

        @Override
        public boolean isChanged() {
            return this.changed;
        }

        @Override
        public RECORD getBefore() {
            this.ensureHasBeforeRecordImage();
            return this.before;
        }

        private void ensureHasBeforeRecordImage() {
            if (this.before == null) {
                this.before = this.loader.copy(this.record);
            }
        }

        @Override
        public boolean isCreated() {
            return this.created;
        }

        @Override
        public ADDITIONAL getAdditionalData() {
            return this.additionalData;
        }
    }
}

