/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.RecordNodeCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipGroupCursor;
import org.neo4j.internal.recordstorage.RelationshipReferenceEncoding;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.storageengine.api.ReadTracer;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

class RecordRelationshipTraversalCursor
extends RecordRelationshipCursor
implements StorageRelationshipTraversalCursor {
    private ReadTracer tracer;
    private RelationshipSelection selection;
    private long originNodeReference;
    private long next = -1L;
    private PageCursor pageCursor;
    private final RecordRelationshipGroupCursor group;
    private GroupState groupState = GroupState.NONE;
    private boolean open;

    RecordRelationshipTraversalCursor(RelationshipStore relationshipStore, RelationshipGroupStore groupStore, RelationshipGroupDegreesStore groupDegreesStore, CursorContext cursorContext) {
        super(relationshipStore, cursorContext);
        this.group = new RecordRelationshipGroupCursor(relationshipStore, groupStore, groupDegreesStore, this.loadMode, cursorContext);
    }

    void init(RecordNodeCursor nodeCursor, RelationshipSelection selection) {
        this.init(nodeCursor.entityReference(), nodeCursor.getNextRel(), nodeCursor.isDense(), selection);
    }

    public void init(long nodeReference, long reference, RelationshipSelection selection) {
        if (reference == -1L) {
            this.resetState();
            return;
        }
        RelationshipReferenceEncoding encoding = RelationshipReferenceEncoding.parseEncoding(reference);
        reference = RelationshipReferenceEncoding.clearEncoding(reference);
        this.init(nodeReference, reference, encoding == RelationshipReferenceEncoding.DENSE, selection);
    }

    private void init(long nodeReference, long reference, boolean isDense, RelationshipSelection selection) {
        if (reference == -1L) {
            this.resetState();
            return;
        }
        this.selection = selection;
        if (isDense) {
            this.groups(nodeReference, reference);
        } else {
            this.chain(nodeReference, reference);
        }
        this.open = true;
    }

    private void chain(long nodeReference, long reference) {
        if (this.pageCursor == null) {
            this.pageCursor = this.relationshipPage(reference);
        }
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.originNodeReference = nodeReference;
        this.next = reference;
    }

    private void groups(long nodeReference, long groupReference) {
        this.setId(-1L);
        this.next = -1L;
        this.groupState = GroupState.INCOMING;
        this.originNodeReference = nodeReference;
        this.group.direct(nodeReference, groupReference);
    }

    public long neighbourNodeReference() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            return target;
        }
        if (target == this.originNodeReference) {
            return source;
        }
        throw new IllegalStateException("NOT PART OF CHAIN");
    }

    public long originNodeReference() {
        return this.originNodeReference;
    }

    public boolean next() {
        boolean traversingDenseNode;
        do {
            if (traversingDenseNode = this.traversingDenseNode()) {
                this.traverseDenseNode();
            }
            if (this.next == -1L) {
                this.resetState();
                return false;
            }
            this.relationshipFull(this, this.next, this.pageCursor);
            this.computeNext();
            if (this.tracer == null) continue;
            this.tracer.onRelationship(this.entityReference());
        } while (!this.inUse() || !traversingDenseNode && !this.selection.test(this.getType(), RelationshipDirection.directionOfStrict((long)this.originNodeReference, (long)this.getFirstNode(), (long)this.getSecondNode())));
        return true;
    }

    private void traverseDenseNode() {
        block5: while (this.next == -1L) {
            switch (this.groupState) {
                case INCOMING: {
                    boolean hasNext = this.group.next();
                    if (!hasNext) {
                        assert (this.next == -1L);
                        return;
                    }
                    if (this.tracer != null) {
                        this.tracer.dbHit();
                    }
                    if (!this.selection.test(this.group.getType())) continue block5;
                    if (this.selection.test(this.group.getType(), RelationshipDirection.INCOMING)) {
                        this.next = this.group.incomingRawId();
                        this.initializePageCursor();
                    }
                    this.groupState = GroupState.OUTGOING;
                    continue block5;
                }
                case OUTGOING: {
                    if (this.selection.test(this.group.getType(), RelationshipDirection.OUTGOING)) {
                        this.initializePageCursor();
                        this.next = this.group.outgoingRawId();
                    }
                    this.groupState = GroupState.LOOP;
                    continue block5;
                }
                case LOOP: {
                    if (this.selection.test(this.group.getType(), RelationshipDirection.LOOP)) {
                        this.initializePageCursor();
                        this.next = this.group.loopsRawId();
                    }
                    this.groupState = GroupState.INCOMING;
                    continue block5;
                }
            }
            throw new IllegalStateException("We cannot get here, but checkstyle forces this!");
        }
    }

    private void initializePageCursor() {
        if (this.pageCursor == null) {
            this.pageCursor = this.relationshipPage(Math.max(this.next, 0L));
        }
    }

    private void computeNext() {
        long source = this.sourceNodeReference();
        long target = this.targetNodeReference();
        if (source == this.originNodeReference) {
            this.next = this.getFirstNextRel();
        } else if (target == this.originNodeReference) {
            this.next = this.getSecondNextRel();
        } else {
            throw new IllegalStateException("NOT PART OF CHAIN! " + this);
        }
    }

    private boolean traversingDenseNode() {
        return this.groupState != GroupState.NONE;
    }

    public void reset() {
        if (this.open) {
            this.open = false;
            this.resetState();
        }
    }

    public void setTracer(ReadTracer tracer) {
        this.tracer = tracer;
    }

    public void removeTracer() {
        this.tracer = null;
    }

    @Override
    public void setForceLoad() {
        super.setForceLoad();
        this.group.loadMode = this.loadMode;
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.group.loadMode = this.loadMode;
        this.next = -1L;
        this.setId(-1L);
        this.groupState = GroupState.NONE;
        this.selection = null;
    }

    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
            this.pageCursor = null;
        }
        this.group.close();
    }

    @Override
    public String toString() {
        if (!this.open) {
            return "RelationshipTraversalCursor[closed state]";
        }
        String dense = "denseNode=" + this.traversingDenseNode();
        return "RelationshipTraversalCursor[id=" + this.getId() + ", open state with: " + dense + ", next=" + this.next + ", , underlying record=" + super.toString() + "]";
    }

    private static enum GroupState {
        INCOMING,
        OUTGOING,
        LOOP,
        NONE;

    }
}

