/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.recordstorage.CommandLockVerification;
import org.neo4j.internal.recordstorage.LockVerificationMonitor;
import org.neo4j.internal.recordstorage.ReadOnlyLogVersionRepository;
import org.neo4j.internal.recordstorage.ReadOnlyTransactionIdStore;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.internal.recordstorage.RecordStorageEngine;
import org.neo4j.internal.recordstorage.SchemaRuleMigrationAccessImpl;
import org.neo4j.internal.recordstorage.SchemaStorage;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.storemigration.IdGeneratorMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.storemigration.RecordStoreRollingUpgradeCompatibility;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersion;
import org.neo4j.kernel.impl.storemigration.RecordStoreVersionCheck;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.RollingUpgradeCompatibility;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

public class RecordStorageEngineFactory
implements StorageEngineFactory {
    public static final String NAME = "record";

    public String name() {
        return NAME;
    }

    public StoreVersionCheck versionCheck(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, PageCache pageCache, LogService logService, PageCacheTracer pageCacheTracer) {
        return new RecordStoreVersionCheck(fs, pageCache, RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout), logService.getInternalLogProvider(), config, pageCacheTracer);
    }

    public StoreVersion versionInformation(String storeVersion) {
        return new RecordStoreVersion(RecordFormatSelector.selectForVersion(storeVersion));
    }

    public StoreVersion versionInformation(StoreId storeId) {
        return this.versionInformation(MetaDataStore.versionLongToString(storeId.getStoreVersion()));
    }

    public RollingUpgradeCompatibility rollingUpgradeCompatibility() {
        return new RecordStoreRollingUpgradeCompatibility(RecordFormatSelector.allFormats());
    }

    public List<StoreMigrationParticipant> migrationParticipants(FileSystemAbstraction fs, Config config, PageCache pageCache, JobScheduler jobScheduler, LogService logService, PageCacheTracer cacheTracer, MemoryTracker memoryTracker) {
        BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();
        RecordStorageMigrator recordStorageMigrator = new RecordStorageMigrator(fs, pageCache, config, logService, jobScheduler, cacheTracer, batchImporterFactory, memoryTracker);
        IdGeneratorMigrator idGeneratorMigrator = new IdGeneratorMigrator(fs, pageCache, config, cacheTracer);
        return List.of(recordStorageMigrator, idGeneratorMigrator);
    }

    public StorageEngine instantiate(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Config config, PageCache pageCache, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, IdGeneratorFactory idGeneratorFactory, IdController idController, DatabaseHealth databaseHealth, LogProvider internalLogProvider, LogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, PageCacheTracer cacheTracer, boolean createStoreIfNotExists, DatabaseReadOnlyChecker readOnlyChecker, MemoryTracker memoryTracker) {
        return new RecordStorageEngine(RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout), config, pageCache, fs, internalLogProvider, userLogProvider, tokenHolders, schemaState, constraintSemantics, indexConfigCompleter, lockService, (Health)databaseHealth, idGeneratorFactory, idController, recoveryCleanupWorkCollector, cacheTracer, createStoreIfNotExists, memoryTracker, readOnlyChecker, new CommandLockVerification.Factory.RealFactory(config), LockVerificationMonitor.Factory.defaultFactory(config));
    }

    public List<Path> listStorageFiles(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) throws IOException {
        if (!fileSystem.fileExists(RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout).metadataStore())) {
            throw new IOException("No storage present at " + databaseLayout + " on " + fileSystem);
        }
        return Arrays.stream(StoreType.values()).map(t -> databaseLayout.file(t.getDatabaseFile())).filter(arg_0 -> ((FileSystemAbstraction)fileSystem).fileExists(arg_0)).collect(Collectors.toList());
    }

    public boolean storageExists(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, PageCache pageCache) {
        return NeoStores.isStorePresent(fileSystem, RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout));
    }

    public TransactionIdStore readOnlyTransactionIdStore(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) throws IOException {
        return new ReadOnlyTransactionIdStore(fileSystem, pageCache, (DatabaseLayout)RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout), cursorContext);
    }

    public LogVersionRepository readOnlyLogVersionRepository(DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) throws IOException {
        return new ReadOnlyLogVersionRepository(pageCache, (DatabaseLayout)RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout), cursorContext);
    }

    public MetadataProvider transactionMetaDataStore(FileSystemAbstraction fs, DatabaseLayout layout, Config config, PageCache pageCache, PageCacheTracer cacheTracer, DatabaseReadOnlyChecker readOnlyChecker) {
        RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)layout);
        RecordFormats recordFormats = RecordFormatSelector.selectForStoreOrConfig(config, databaseLayout, fs, pageCache, (LogProvider)NullLogProvider.getInstance(), cacheTracer);
        ScanOnOpenReadOnlyIdGeneratorFactory idGeneratorFactory = readOnlyChecker.isReadOnly() ? new ScanOnOpenReadOnlyIdGeneratorFactory() : new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate(), databaseLayout.getDatabaseName());
        return new StoreFactory((DatabaseLayout)databaseLayout, config, (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, recordFormats, (LogProvider)NullLogProvider.getInstance(), cacheTracer, readOnlyChecker, (ImmutableSet<OpenOption>)Sets.immutable.empty()).openNeoStores(StoreType.META_DATA).getMetaDataStore();
    }

    public StoreId storeId(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) throws IOException {
        return MetaDataStore.getStoreId(pageCache, RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout).metadataStore(), databaseLayout.getDatabaseName(), cursorContext);
    }

    public void setStoreId(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext, StoreId storeId, long upgradeTxChecksum, long upgradeTxCommitTimestamp) throws IOException {
        MetaDataStore.setStoreId(pageCache, RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout).metadataStore(), storeId, upgradeTxChecksum, upgradeTxCommitTimestamp, databaseLayout.getDatabaseName(), cursorContext);
    }

    public void setExternalStoreUUID(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext, UUID externalStoreId) throws IOException {
        MetaDataStore.setExternalStoreUUID(pageCache, RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout).metadataStore(), externalStoreId, databaseLayout.getDatabaseName(), cursorContext);
    }

    public Optional<UUID> databaseIdUuid(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) {
        return MetaDataStore.getDatabaseIdUuid(pageCache, RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout).metadataStore(), databaseLayout.getDatabaseName(), cursorContext);
    }

    public SchemaRuleMigrationAccess schemaRuleMigrationAccess(FileSystemAbstraction fs, PageCache pageCache, Config config, DatabaseLayout layout, LogService logService, String recordFormats, PageCacheTracer cacheTracer, CursorContext cursorContext, MemoryTracker memoryTracker) {
        RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)layout);
        RecordFormats formats = RecordFormatSelector.selectForVersion(recordFormats);
        StoreFactory factory = new StoreFactory((DatabaseLayout)databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate(), databaseLayout.getDatabaseName()), pageCache, fs, formats, logService.getInternalLogProvider(), cacheTracer, DatabaseReadOnlyChecker.writable(), (ImmutableSet<OpenOption>)Sets.immutable.empty());
        NeoStores stores = factory.openNeoStores(true, StoreType.SCHEMA, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY);
        try {
            stores.start(cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return RecordStorageEngineFactory.createMigrationTargetSchemaRuleAccess(stores, cursorContext, memoryTracker);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<SchemaRule> loadSchemaRules(FileSystemAbstraction fs, PageCache pageCache, Config config, DatabaseLayout layout, CursorContext cursorContext) {
        RecordDatabaseLayout databaseLayout = RecordDatabaseLayout.convert((DatabaseLayout)layout);
        StoreFactory factory = new StoreFactory((DatabaseLayout)databaseLayout, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate(), databaseLayout.getDatabaseName()), pageCache, fs, (LogProvider)NullLogProvider.getInstance(), PageCacheTracer.NULL, DatabaseReadOnlyChecker.readOnly());
        try (NeoStores stores = factory.openNeoStores(false, StoreType.SCHEMA, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY);){
            ArrayList<SchemaRule> arrayList;
            try (CachedStoreCursors storeCursors = new CachedStoreCursors(stores, cursorContext);){
                stores.start(cursorContext);
                TokenHolders tokenHolders = RecordStorageEngineFactory.tokenHoldersForSchemaStore(stores, (TokenCreator)new ReadOnlyTokenCreator(), (StoreCursors)storeCursors);
                ArrayList<SchemaRule> rules = new ArrayList<SchemaRule>();
                new SchemaStorage(stores.getSchemaStore(), tokenHolders, () -> KernelVersion.LATEST).getAll((StoreCursors)storeCursors).forEach(rules::add);
                arrayList = rules;
            }
            return arrayList;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public CommandReaderFactory commandReaderFactory() {
        return RecordStorageCommandReaderFactory.INSTANCE;
    }

    public RecordDatabaseLayout databaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        return RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)databaseName);
    }

    public StorageFilesState checkStoreFileState(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache) {
        RecordDatabaseLayout recordLayout = RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout);
        Set storeFiles = recordLayout.storeFiles();
        storeFiles.remove(recordLayout.countStore());
        storeFiles.remove(recordLayout.relationshipGroupDegreesStore());
        storeFiles.remove(recordLayout.indexStatisticsStore());
        storeFiles.remove(recordLayout.labelScanStore());
        storeFiles.remove(recordLayout.relationshipTypeScanStore());
        boolean allStoreFilesExist = storeFiles.stream().allMatch(arg_0 -> ((FileSystemAbstraction)fs).fileExists(arg_0));
        if (!allStoreFilesExist) {
            return StorageFilesState.unrecoverableState((Collection)storeFiles.stream().filter(file -> !fs.fileExists(file)).collect(Collectors.toList()));
        }
        boolean allIdFilesExist = recordLayout.idFiles().stream().allMatch(arg_0 -> ((FileSystemAbstraction)fs).fileExists(arg_0));
        if (!allIdFilesExist) {
            return StorageFilesState.recoverableState();
        }
        return StorageFilesState.recoveredState();
    }

    public static SchemaRuleMigrationAccess createMigrationTargetSchemaRuleAccess(NeoStores stores, CursorContext cursorContext, MemoryTracker memoryTracker) {
        SchemaStore dstSchema = stores.getSchemaStore();
        TokenCreator propertyKeyTokenCreator = (name, internal) -> {
            try (CachedStoreCursors storeCursors = new CachedStoreCursors(stores, cursorContext);){
                PropertyKeyTokenStore keyTokenStore = stores.getPropertyKeyTokenStore();
                DynamicStringStore nameStore = keyTokenStore.getNameStore();
                byte[] bytes = PropertyStore.encodeString(name);
                ArrayList<DynamicRecord> nameRecords = new ArrayList<DynamicRecord>();
                AbstractDynamicStore.allocateRecordsFromBytes(nameRecords, bytes, nameStore, cursorContext, memoryTracker);
                nameRecords.forEach(record -> nameStore.prepareForCommit(record, cursorContext));
                try (PageCursor cursor = storeCursors.writeCursor(RecordCursorTypes.DYNAMIC_PROPERTY_KEY_TOKEN_CURSOR);){
                    nameRecords.forEach(record -> nameStore.updateRecord(record, cursor, cursorContext, (StoreCursors)storeCursors));
                }
                nameRecords.forEach(record -> nameStore.setHighestPossibleIdInUse(record.getId()));
                int nameId = ((DynamicRecord)Iterables.first(nameRecords)).getIntId();
                PropertyKeyTokenRecord keyTokenRecord = (PropertyKeyTokenRecord)keyTokenStore.newRecord();
                long tokenId = keyTokenStore.nextId(cursorContext);
                keyTokenRecord.setId(tokenId);
                keyTokenRecord.initialize(true, nameId);
                keyTokenRecord.setInternal(internal);
                keyTokenRecord.setCreated();
                keyTokenStore.prepareForCommit(keyTokenRecord, cursorContext);
                try (PageCursor pageCursor = storeCursors.writeCursor(RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR);){
                    keyTokenStore.updateRecord(keyTokenRecord, pageCursor, cursorContext, (StoreCursors)storeCursors);
                }
                keyTokenStore.setHighestPossibleIdInUse(keyTokenRecord.getId());
                int n = Math.toIntExact(tokenId);
                return n;
            }
        };
        CachedStoreCursors storeCursors = new CachedStoreCursors(stores, cursorContext);
        TokenHolders dstTokenHolders = RecordStorageEngineFactory.tokenHoldersForSchemaStore(stores, propertyKeyTokenCreator, (StoreCursors)storeCursors);
        return new SchemaRuleMigrationAccessImpl(stores, new SchemaStorage(dstSchema, dstTokenHolders, () -> KernelVersion.LATEST), cursorContext, memoryTracker, (StoreCursors)storeCursors);
    }

    private static TokenHolders tokenHoldersForSchemaStore(NeoStores stores, TokenCreator propertyKeyTokenCreator, StoreCursors storeCursors) {
        DelegatingTokenHolder propertyKeyTokens = new DelegatingTokenHolder(propertyKeyTokenCreator, "PropertyKey");
        TokenHolders dstTokenHolders = new TokenHolders((TokenHolder)propertyKeyTokens, StoreTokens.createReadOnlyTokenHolder("Label"), StoreTokens.createReadOnlyTokenHolder("RelationshipType"));
        dstTokenHolders.propertyKeyTokens().setInitialTokens(stores.getPropertyKeyTokenStore().getTokens(storeCursors));
        return dstTokenHolders;
    }
}

