/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacy;

import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.kernel.api.exceptions.schema.MalformedSchemaRuleException;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.storemigration.legacy.SchemaRuleSerialization35;
import org.neo4j.logging.LogProvider;
import org.neo4j.util.VisibleForTesting;

public class SchemaStore35
extends AbstractDynamicStore {
    public static final String TYPE_DESCRIPTOR = "SchemaStore";
    private static final int BLOCK_SIZE = 56;

    public SchemaStore35(Path path, Path idFile, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider, RecordFormats recordFormats, DatabaseReadOnlyChecker readOnlyChecker, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(path, idFile, conf, idType, idGeneratorFactory, pageCache, logProvider, TYPE_DESCRIPTOR, 56, recordFormats.dynamic(), recordFormats.storeVersion(), readOnlyChecker, databaseName, openOptions);
    }

    @Override
    @VisibleForTesting
    public void initialise(boolean createIfNotExists, CursorContext cursorContext) {
        super.initialise(createIfNotExists, cursorContext);
    }

    static SchemaRule readSchemaRule(long id, Collection<DynamicRecord> records, byte[] buffer) throws MalformedSchemaRuleException {
        ByteBuffer scratchBuffer = SchemaStore35.concatData(records, buffer);
        return SchemaRuleSerialization35.deserialize(id, scratchBuffer);
    }
}

