/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class IndexEntryConflictException
extends KernelException {
    private final ValueTuple propertyValues;
    private final long addedNodeId;
    private final long existingNodeId;

    public IndexEntryConflictException(String message, Throwable cause) {
        super((Status)Status.Schema.ConstraintViolation, message, new Object[]{cause});
        this.propertyValues = null;
        this.addedNodeId = -1L;
        this.existingNodeId = -1L;
    }

    public IndexEntryConflictException(long existingNodeId, long addedNodeId, Value ... propertyValue) {
        this(existingNodeId, addedNodeId, ValueTuple.of((Value[])propertyValue));
    }

    public IndexEntryConflictException(long existingNodeId, long addedNodeId, ValueTuple propertyValues) {
        super((Status)Status.Schema.ConstraintViolation, "Both node %d and node %d share the property value %s", new Object[]{existingNodeId, addedNodeId, propertyValues});
        this.existingNodeId = existingNodeId;
        this.addedNodeId = addedNodeId;
        this.propertyValues = propertyValues;
    }

    public String evidenceMessage(TokenNameLookup tokenNameLookup, SchemaDescriptor schema) {
        assert (schema.getPropertyIds().length == this.propertyValues.size());
        String labelName = Arrays.stream(schema.getEntityTokenIds()).mapToObj(arg_0 -> ((TokenNameLookup)tokenNameLookup).labelGetName(arg_0)).collect(Collectors.joining("`, `", "`", "`"));
        if (this.addedNodeId == -1L) {
            return String.format("Node(%d) already exists with label %s and %s", this.existingNodeId, labelName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
        }
        return String.format("Both Node(%d) and Node(%d) have the label %s and %s", this.existingNodeId, this.addedNodeId, labelName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
    }

    public ValueTuple getPropertyValues() {
        return this.propertyValues;
    }

    public Value getSinglePropertyValue() {
        return this.propertyValues.getOnlyValue();
    }

    public long getAddedNodeId() {
        return this.addedNodeId;
    }

    public long getExistingNodeId() {
        return this.existingNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexEntryConflictException that = (IndexEntryConflictException)((Object)o);
        return this.addedNodeId == that.addedNodeId && this.existingNodeId == that.existingNodeId && !(this.propertyValues == null ? that.propertyValues != null : !this.propertyValues.equals((Object)that.propertyValues));
    }

    public int hashCode() {
        int result = this.propertyValues != null ? this.propertyValues.hashCode() : 0;
        result = 31 * result + (int)(this.addedNodeId ^ this.addedNodeId >>> 32);
        result = 31 * result + (int)(this.existingNodeId ^ this.existingNodeId >>> 32);
        return result;
    }

    public String toString() {
        return "IndexEntryConflictException{propertyValues=" + this.propertyValues + ", addedNodeId=" + this.addedNodeId + ", existingNodeId=" + this.existingNodeId + "}";
    }

    private String propertyString(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        StringBuilder sb = new StringBuilder();
        String sep = propertyIds.length > 1 ? "properties " : "property ";
        for (int i = 0; i < propertyIds.length; ++i) {
            sb.append(sep);
            sep = ", ";
            sb.append('`');
            sb.append(tokenNameLookup.propertyKeyGetName(propertyIds[i]));
            sb.append("` = ");
            sb.append(this.propertyValues.valueAt(i).prettyPrint());
        }
        return sb.toString();
    }
}

