/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.time.Duration;
import org.neo4j.bolt.transport.pipeline.AuthenticationTimeoutHandler;
import org.neo4j.bolt.transport.pipeline.BytesAccumulator;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class UnauthenticatedChannelProtector
implements ChannelProtector {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(UnauthenticatedChannelProtector.class);
    private final Duration channelTimeout;
    private final ChannelPipeline pipeline;
    private final long maxMessageSize;
    private final MemoryTracker memoryTracker;
    private AuthenticationTimeoutHandler timeoutHandler;

    public UnauthenticatedChannelProtector(ChannelPipeline pipeline, Duration channelTimeout, long maxMessageSize, MemoryTracker memoryTracker) {
        this.channelTimeout = channelTimeout;
        this.pipeline = pipeline;
        this.maxMessageSize = maxMessageSize;
        this.memoryTracker = memoryTracker;
        memoryTracker.allocateHeap(AuthenticationTimeoutHandler.SHALLOW_SIZE);
        this.timeoutHandler = new AuthenticationTimeoutHandler(channelTimeout);
    }

    @Override
    public void afterChannelCreated() {
        this.pipeline.addLast(new ChannelHandler[]{this.timeoutHandler});
    }

    @Override
    public void beforeBoltProtocolInstalled() {
        this.memoryTracker.allocateHeap(BytesAccumulator.SHALLOW_SIZE);
        this.pipeline.addLast(new ChannelHandler[]{new BytesAccumulator(this.maxMessageSize)});
    }

    @Override
    public void afterRequestReceived() {
        if (this.timeoutHandler != null) {
            this.timeoutHandler.setRequestReceived(true);
        }
    }

    @Override
    public void disable() {
        this.pipeline.remove(AuthenticationTimeoutHandler.class);
        this.timeoutHandler = null;
        this.pipeline.remove(BytesAccumulator.class);
        this.memoryTracker.releaseHeap(AuthenticationTimeoutHandler.SHALLOW_SIZE + BytesAccumulator.SHALLOW_SIZE);
    }
}

