/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v44.messaging.decoder;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.v44.messaging.decoder.MessageMetadataParser;
import org.neo4j.bolt.v44.messaging.request.RouteMessage;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class RouteMessageDecoder
implements RequestMessageDecoder {
    public static final String DB_KEY = "db";
    private final BoltResponseHandler responseHandler;
    private final BookmarksParser bookmarksParser;

    public RouteMessageDecoder(BoltResponseHandler responseHandler, BookmarksParser bookmarksParser) {
        this.responseHandler = responseHandler;
        this.bookmarksParser = bookmarksParser;
    }

    @Override
    public int signature() {
        return 102;
    }

    @Override
    public BoltResponseHandler responseHandler() {
        return this.responseHandler;
    }

    @Override
    public RequestMessage decode(Neo4jPack.Unpacker unpacker) throws IOException {
        MapValue routingContext = unpacker.unpackMap();
        List<Bookmark> bookmarkList = this.bookmarksParser.parseBookmarks(unpacker.unpack());
        MapValue meta = unpacker.unpackMap();
        String databaseName = Optional.of(meta.get(DB_KEY)).filter(any -> any != Values.NO_VALUE && any instanceof TextValue).map(any -> ((TextValue)any).stringValue()).orElse(null);
        String impersonatedUser = MessageMetadataParser.parseImpersonatedUser(meta);
        return this.newRouteMessage(routingContext, bookmarkList, meta, databaseName, impersonatedUser);
    }

    protected RequestMessage newRouteMessage(MapValue routingContext, List<Bookmark> bookmarkList, MapValue meta, String databaseName, String impersonatedUser) {
        return new RouteMessage(routingContext, bookmarkList, databaseName, impersonatedUser);
    }
}

