/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.marshal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.marshal.ChannelMarshal;

public class StringChannelMarshal
implements ChannelMarshal<String> {
    public static final int NULL_STRING_LENGTH = -1;

    @Override
    public void marshal(String string, WritableChannel channel) throws IOException {
        if (string == null) {
            channel.putInt(-1);
        } else {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            channel.putInt(bytes.length);
            channel.put(bytes, bytes.length);
        }
    }

    @Override
    public String unmarshal(ReadableChannel channel) throws IOException {
        int len = channel.getInt();
        if (len == -1) {
            return null;
        }
        byte[] stringBytes = new byte[len];
        channel.get(stringBytes, stringBytes.length);
        return new String(stringBytes, StandardCharsets.UTF_8);
    }
}

