/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.operations;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.runtime.ExpressionCursors;
import org.neo4j.cypher.internal.runtime.makeValueNeoSafe;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;

public final class CypherCoercions {
    private static final Map<Class<? extends Neo4jTypes.AnyType>, Coercer> CONVERTERS = new HashMap<Class<? extends Neo4jTypes.AnyType>, Coercer>();

    private CypherCoercions() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static Value asStorableValue(AnyValue value) {
        return makeValueNeoSafe.apply(value);
    }

    public static TextValue asTextValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof TextValue)) {
            throw CypherCoercions.cantCoerce(value, "String");
        }
        return (TextValue)value;
    }

    public static VirtualNodeValue asNodeValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof VirtualNodeValue)) {
            throw CypherCoercions.cantCoerce(value, "Node");
        }
        return (VirtualNodeValue)value;
    }

    public static VirtualRelationshipValue asRelationshipValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof VirtualRelationshipValue)) {
            throw CypherCoercions.cantCoerce(value, "Relationship");
        }
        return (VirtualRelationshipValue)value;
    }

    public static VirtualPathValue asPathValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof VirtualPathValue)) {
            throw CypherCoercions.cantCoerce(value, "Path");
        }
        return (VirtualPathValue)value;
    }

    public static IntegralValue asIntegralValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value, "Integer");
        }
        return Values.longValue((long)((NumberValue)value).longValue());
    }

    public static FloatingPointValue asFloatingPointValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value, "Float");
        }
        return Values.doubleValue((double)((NumberValue)value).doubleValue());
    }

    public static BooleanValue asBooleanValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof BooleanValue)) {
            throw CypherCoercions.cantCoerce(value, "Boolean");
        }
        return (BooleanValue)value;
    }

    public static NumberValue asNumberValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof NumberValue)) {
            throw CypherCoercions.cantCoerce(value, "Number");
        }
        return (NumberValue)value;
    }

    public static PointValue asPointValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof PointValue)) {
            throw CypherCoercions.cantCoerce(value, "Point");
        }
        return (PointValue)value;
    }

    public static DateValue asDateValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof DateValue)) {
            throw CypherCoercions.cantCoerce(value, "Date");
        }
        return (DateValue)value;
    }

    public static TimeValue asTimeValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof TimeValue)) {
            throw CypherCoercions.cantCoerce(value, "Time");
        }
        return (TimeValue)value;
    }

    public static LocalTimeValue asLocalTimeValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof LocalTimeValue)) {
            throw CypherCoercions.cantCoerce(value, "LocalTime");
        }
        return (LocalTimeValue)value;
    }

    public static LocalDateTimeValue asLocalDateTimeValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof LocalDateTimeValue)) {
            throw CypherCoercions.cantCoerce(value, "LocalDateTime");
        }
        return (LocalDateTimeValue)value;
    }

    public static DateTimeValue asDateTimeValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof DateTimeValue)) {
            throw CypherCoercions.cantCoerce(value, "DateTime");
        }
        return (DateTimeValue)value;
    }

    public static DurationValue asDurationValue(AnyValue value) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (!(value instanceof DurationValue)) {
            throw CypherCoercions.cantCoerce(value, "Duration");
        }
        return (DurationValue)value;
    }

    public static MapValue asMapValue(AnyValue value, DbAccess access, NodeCursor nodeCursor, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        if (value instanceof MapValue) {
            return (MapValue)value;
        }
        if (value instanceof VirtualNodeValue) {
            return access.nodeAsMap(((VirtualNodeValue)value).id(), nodeCursor, propertyCursor);
        }
        if (value instanceof VirtualRelationshipValue) {
            return access.relationshipAsMap(((VirtualRelationshipValue)value).id(), relationshipCursor, propertyCursor);
        }
        throw CypherCoercions.cantCoerce(value, "Map");
    }

    public static ListValue asList(AnyValue value, Neo4jTypes.AnyType innerType, DbAccess access, ExpressionCursors cursors) {
        assert (value != Values.NO_VALUE) : "NO_VALUE checks need to happen outside this call";
        return new ListCoercer().apply(value, innerType, access, cursors);
    }

    private static CypherTypeException cantCoerce(AnyValue value, String type) {
        return new CypherTypeException(String.format("Can't coerce `%s` to %s", value, type));
    }

    private static Neo4jTypes.AnyType nextInner(Neo4jTypes.AnyType type) {
        if (type instanceof Neo4jTypes.ListType) {
            return ((Neo4jTypes.ListType)type).innerType();
        }
        return type;
    }

    private static ListValue fastListConversion(AnyValue value) {
        if (value instanceof ListValue) {
            return (ListValue)value;
        }
        if (value instanceof ArrayValue) {
            return VirtualValues.fromArray((ArrayValue)((ArrayValue)value));
        }
        if (value instanceof VirtualPathValue) {
            return ((VirtualPathValue)value).asList();
        }
        throw CypherCoercions.cantCoerce(value, "List");
    }

    static {
        CONVERTERS.put(Neo4jTypes.NTAny.getClass(), (a, ignore1, ignore2, cursors) -> a);
        CONVERTERS.put(Neo4jTypes.NTString.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asTextValue(a));
        CONVERTERS.put(Neo4jTypes.NTNumber.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asNumberValue(a));
        CONVERTERS.put(Neo4jTypes.NTInteger.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asIntegralValue(a));
        CONVERTERS.put(Neo4jTypes.NTFloat.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asFloatingPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTBoolean.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asBooleanValue(a));
        CONVERTERS.put(Neo4jTypes.NTMap.getClass(), (a, ignore, c, cursors) -> CypherCoercions.asMapValue(a, c, cursors.nodeCursor(), cursors.relationshipScanCursor(), cursors.propertyCursor()));
        CONVERTERS.put(Neo4jTypes.NTNode.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asNodeValue(a));
        CONVERTERS.put(Neo4jTypes.NTRelationship.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asRelationshipValue(a));
        CONVERTERS.put(Neo4jTypes.NTPath.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asPathValue(a));
        CONVERTERS.put(Neo4jTypes.NTGeometry.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTPoint.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asPointValue(a));
        CONVERTERS.put(Neo4jTypes.NTDateTime.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asDateTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTLocalDateTime.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asLocalDateTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTDate.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asDateValue(a));
        CONVERTERS.put(Neo4jTypes.NTTime.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTLocalTime.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asLocalTimeValue(a));
        CONVERTERS.put(Neo4jTypes.NTDuration.getClass(), (a, ignore1, ignore2, cursors) -> CypherCoercions.asDurationValue(a));
        CONVERTERS.put(Neo4jTypes.ListType.class, new ListCoercer());
    }

    private static class ListCoercer
    implements Coercer {
        private ListCoercer() {
        }

        public ListValue apply(AnyValue value, Neo4jTypes.AnyType innerType, DbAccess access, ExpressionCursors cursors) {
            if (innerType == Neo4jTypes.NTAny) {
                return CypherCoercions.fastListConversion(value);
            }
            if (!(value instanceof SequenceValue)) {
                throw CypherCoercions.cantCoerce(value, "List");
            }
            SequenceValue listValue = (SequenceValue)value;
            Coercer innerCoercer = CONVERTERS.get(innerType.getClass());
            Neo4jTypes.AnyType nextInner = CypherCoercions.nextInner(innerType);
            if (listValue.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                int length = listValue.length();
                ListValueBuilder builder = ListValueBuilder.newListBuilder((int)length);
                for (int i = 0; i < length; ++i) {
                    AnyValue nextItem = listValue.value(i);
                    builder.add((AnyValue)(nextItem == Values.NO_VALUE ? Values.NO_VALUE : innerCoercer.apply(nextItem, nextInner, access, cursors)));
                }
                return builder.build();
            }
            ListValueBuilder builder = ListValueBuilder.newListBuilder();
            int i = 0;
            for (AnyValue anyValue : listValue) {
                AnyValue nextItem = listValue.value(i);
                builder.add((AnyValue)(nextItem == Values.NO_VALUE ? Values.NO_VALUE : innerCoercer.apply(anyValue, nextInner, access, cursors)));
            }
            return builder.build();
        }
    }

    @FunctionalInterface
    static interface Coercer {
        public AnyValue apply(AnyValue var1, Neo4jTypes.AnyType var2, DbAccess var3, ExpressionCursors var4);
    }

    private static class ListMapper
    implements ValueMapper<ListValue> {
        private ListMapper() {
        }

        public ListValue mapPath(VirtualPathValue value) {
            return null;
        }

        public ListValue mapNode(VirtualNodeValue value) {
            return null;
        }

        public ListValue mapRelationship(VirtualRelationshipValue value) {
            return null;
        }

        public ListValue mapMap(MapValue value) {
            return null;
        }

        public ListValue mapNoValue() {
            return null;
        }

        public ListValue mapSequence(SequenceValue value) {
            return null;
        }

        public ListValue mapText(TextValue value) {
            return null;
        }

        public ListValue mapBoolean(BooleanValue value) {
            return null;
        }

        public ListValue mapNumber(NumberValue value) {
            return null;
        }

        public ListValue mapDateTime(DateTimeValue value) {
            return null;
        }

        public ListValue mapLocalDateTime(LocalDateTimeValue value) {
            return null;
        }

        public ListValue mapDate(DateValue value) {
            return null;
        }

        public ListValue mapTime(TimeValue value) {
            return null;
        }

        public ListValue mapLocalTime(LocalTimeValue value) {
            return null;
        }

        public ListValue mapDuration(DurationValue value) {
            return null;
        }

        public ListValue mapPoint(PointValue value) {
            return null;
        }
    }
}

