/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.identity;

import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.marshal.ChannelMarshal;
import org.neo4j.io.state.SimpleFileStorage;
import org.neo4j.io.state.SimpleStorage;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.util.Id;

public abstract class AbstractIdentityModule
extends LifecycleAdapter
implements DiagnosticsProvider,
ServerIdentity {
    protected static <T extends Id> T readOrGenerate(SimpleStorage<T> storage, Log log, Class<T> type, Function<UUID, ? extends T> creator, Supplier<UUID> uuid) {
        Id myself;
        try {
            if (storage.exists()) {
                myself = (Id)storage.readState();
                if (myself == null) {
                    throw new IllegalStateException(String.format("%s storage was found on disk, but it could not be read correctly", type.getSimpleName()));
                }
                log.info(String.format("Found %s on disk: %s (%s)", type.getSimpleName(), myself, myself.uuid()));
            } else {
                UUID newUuid = uuid.get();
                myself = (Id)creator.apply(newUuid);
                storage.writeState((Object)myself);
                log.info(String.format("Generated new %s: %s (%s)", type.getSimpleName(), myself, newUuid));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)myself;
    }

    protected static SimpleStorage<ServerId> createServerIdStorage(FileSystemAbstraction fs, Path serverIdFile) {
        return new SimpleFileStorage(fs, serverIdFile, (ChannelMarshal)ServerId.Marshal.INSTANCE);
    }

    public String getDiagnosticsName() {
        return "Global Server Identity";
    }

    public void dump(DiagnosticsLogger logger) {
        logger.log(String.format("ServerId is: %s", this.serverId().toString()));
    }
}

