/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph.versions;

import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KnownSystemComponentVersion;
import org.neo4j.dbms.database.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;

public abstract class KnownCommunityTopologyComponentVersion
extends KnownSystemComponentVersion {
    KnownCommunityTopologyComponentVersion(ComponentVersion componentVersion) {
        super(componentVersion, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
    }

    public void initializeTopologyGraph(Transaction tx) {
        this.setDatabaseAccessToReadWrite(tx);
        this.addDatabaseNameNodes(tx);
    }

    protected void setDatabaseAccessToReadWrite(Transaction tx) {
        ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL);
        nodes.stream().forEach(node -> node.setProperty("access", (Object)TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString()));
    }

    protected void addDatabaseNameNodes(Transaction tx) {
        ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL);
        nodes.stream().forEach(databaseNode -> {
            if (!this.hasPrimaryAlias((Node)databaseNode)) {
                Node nameNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
                nameNode.setProperty("name", databaseNode.getProperty("name"));
                nameNode.setProperty("primary", (Object)true);
                nameNode.createRelationshipTo(databaseNode, TopologyGraphDbmsModel.TARGETS_RELATIONSHIP);
            }
        });
    }

    private boolean hasPrimaryAlias(Node node) {
        boolean hasPrimary = false;
        for (Relationship relationship : node.getRelationships(new RelationshipType[]{TopologyGraphDbmsModel.TARGETS_RELATIONSHIP})) {
            Node nameNode = relationship.getStartNode();
            if (!nameNode.getProperty("primary").equals(true)) continue;
            hasPrimary = true;
        }
        return hasPrimary;
    }

    public abstract void upgradeTopologyGraph(Transaction var1, int var2) throws Exception;
}

