/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import io.netty.buffer.ByteBufAllocator;
import java.nio.file.Path;
import java.time.Clock;
import java.util.function.Supplier;
import org.neo4j.annotations.api.IgnoreApiCheck;
import org.neo4j.bolt.transaction.StatementProcessorTxManager;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.buffer.CentralBufferMangerHolder;
import org.neo4j.buffer.NettyMemoryManagerWrapper;
import org.neo4j.capabilities.CapabilitiesService;
import org.neo4j.capabilities.DBMSCapabilities;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.internal.collector.RecentQueryBuffer;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessProvider;
import org.neo4j.io.bufferpool.ByteBufferManger;
import org.neo4j.io.bufferpool.impl.NeoByteBufferPool;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemLifecycleAdapter;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.diagnostics.providers.DbmsDiagnosticsManager;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategies;
import org.neo4j.kernel.extension.GlobalExtensions;
import org.neo4j.kernel.extension.context.GlobalExtensionContext;
import org.neo4j.kernel.impl.cache.VmPauseMonitorComponent;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.impl.pagecache.PageCacheLifecycle;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.CapacityLimitingBlockAllocatorDecorator;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.watcher.DefaultFileSystemWatcherService;
import org.neo4j.kernel.impl.util.watcher.FileSystemWatcherService;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.internal.Version;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.internal.locker.GlobalLockerService;
import org.neo4j.kernel.internal.locker.Locker;
import org.neo4j.kernel.internal.locker.LockerLifecycleAdapter;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.logging.log4j.Log4jLogProvider;
import org.neo4j.logging.log4j.LogConfig;
import org.neo4j.logging.log4j.Neo4jLoggerContext;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.memory.MemoryGroup;
import org.neo4j.memory.MemoryPools;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.time.Clocks;
import org.neo4j.time.SystemNanoClock;

@IgnoreApiCheck
public class GlobalModule {
    private final PageCache pageCache;
    private final Monitors globalMonitors;
    private final Dependencies globalDependencies;
    private final LogService logService;
    private final LifeSupport globalLife;
    private final Neo4jLayout neo4jLayout;
    private final DbmsInfo dbmsInfo;
    private final DbmsDiagnosticsManager dbmsDiagnosticsManager;
    private final Tracers tracers;
    private final Config globalConfig;
    private final FileSystemAbstraction fileSystem;
    private final GlobalExtensions globalExtensions;
    private final Iterable<ExtensionFactory<?>> extensionFactories;
    private final JobScheduler jobScheduler;
    private final SystemNanoClock globalClock;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final ConnectorPortRegister connectorPortRegister;
    private final CompositeDatabaseAvailabilityGuard globalAvailabilityGuard;
    private final FileSystemWatcherService fileSystemWatcher;
    private final DatabaseEventListeners databaseEventListeners;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final DependencyResolver externalDependencyResolver;
    private final FileLockerService fileLockerService;
    private final MemoryPools memoryPools;
    private final GlobalMemoryGroupTracker transactionsMemoryPool;
    private final GlobalMemoryGroupTracker otherMemoryPool;
    private final SystemGraphComponents systemGraphComponents;
    private final CentralBufferMangerHolder centralBufferMangerHolder;
    private final TransactionManager transactionManager;
    private final IOControllerService ioControllerService;
    private final CapabilitiesService capabilitiesService;

    public GlobalModule(Config globalConfig, DbmsInfo dbmsInfo, ExternalDependencies externalDependencies) {
        this.externalDependencyResolver = externalDependencies.dependencies() != null ? externalDependencies.dependencies() : new Dependencies();
        this.dbmsInfo = dbmsInfo;
        this.globalDependencies = new Dependencies();
        this.globalDependencies.satisfyDependency((Object)dbmsInfo);
        this.globalClock = (SystemNanoClock)this.globalDependencies.satisfyDependency((Object)this.createClock());
        this.globalLife = this.createLife();
        this.neo4jLayout = Neo4jLayout.of((Config)globalConfig);
        this.globalConfig = (Config)this.globalDependencies.satisfyDependency((Object)globalConfig);
        this.fileSystem = this.tryResolveOrCreate(FileSystemAbstraction.class, this::createFileSystemAbstraction);
        this.globalDependencies.satisfyDependency((Object)this.fileSystem);
        this.globalLife.add((Lifecycle)new FileSystemLifecycleAdapter(this.fileSystem));
        this.logService = (LogService)this.globalDependencies.satisfyDependency((Object)this.createLogService(externalDependencies.userLogProvider()));
        globalConfig.setLogger(this.logService.getInternalLog(Config.class));
        this.globalMonitors = externalDependencies.monitors() == null ? new Monitors() : externalDependencies.monitors();
        this.globalDependencies.satisfyDependency((Object)this.globalMonitors);
        JobScheduler createdOrResolvedScheduler = this.tryResolveOrCreate(JobScheduler.class, this::createJobScheduler);
        this.jobScheduler = (JobScheduler)this.globalLife.add((Lifecycle)((JobScheduler)this.globalDependencies.satisfyDependency((Object)createdOrResolvedScheduler)));
        this.fileLockerService = this.createFileLockerService();
        Locker storeLocker = this.fileLockerService.createStoreLocker(this.fileSystem, this.neo4jLayout);
        this.globalLife.add((Lifecycle)((LockerLifecycleAdapter)this.globalDependencies.satisfyDependency((Object)new LockerLifecycleAdapter(storeLocker))));
        new JvmChecker(this.logService.getInternalLog(JvmChecker.class), new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        this.memoryPools = new MemoryPools(((Boolean)globalConfig.get(GraphDatabaseSettings.memory_tracking)).booleanValue());
        this.otherMemoryPool = this.memoryPools.pool(MemoryGroup.OTHER, 0L, null);
        this.transactionsMemoryPool = this.memoryPools.pool(MemoryGroup.TRANSACTION, ((Long)globalConfig.get(GraphDatabaseSettings.memory_transaction_global_max_size)).longValue(), GraphDatabaseSettings.memory_transaction_global_max_size.name());
        globalConfig.addListener(GraphDatabaseSettings.memory_transaction_global_max_size, (before, after) -> this.transactionsMemoryPool.setSize(after.longValue()));
        this.globalDependencies.satisfyDependency((Object)this.memoryPools);
        this.centralBufferMangerHolder = this.crateCentralBufferManger();
        RecentQueryBuffer recentQueryBuffer = new RecentQueryBuffer(((Integer)globalConfig.get(GraphDatabaseInternalSettings.data_collector_max_recent_query_count)).intValue(), this.memoryPools.pool(MemoryGroup.RECENT_QUERY_BUFFER, 0L, null).getPoolMemoryTracker());
        this.globalDependencies.satisfyDependency((Object)recentQueryBuffer);
        this.systemGraphComponents = this.tryResolveOrCreate(SystemGraphComponents.class, SystemGraphComponents::new);
        this.globalDependencies.satisfyDependency((Object)this.systemGraphComponents);
        this.globalLife.add((Lifecycle)new VmPauseMonitorComponent(globalConfig, this.logService.getInternalLog(VmPauseMonitorComponent.class), this.jobScheduler, this.globalMonitors));
        this.globalAvailabilityGuard = new CompositeDatabaseAvailabilityGuard((Clock)this.globalClock);
        this.globalDependencies.satisfyDependency((Object)this.globalAvailabilityGuard);
        this.globalLife.setLast((Lifecycle)this.globalAvailabilityGuard);
        String desiredImplementationName = (String)globalConfig.get(GraphDatabaseInternalSettings.tracer);
        this.tracers = (Tracers)this.globalDependencies.satisfyDependency((Object)new Tracers(desiredImplementationName, this.logService.getInternalLog(Tracers.class), this.globalMonitors, this.jobScheduler, this.globalClock, globalConfig));
        this.globalDependencies.satisfyDependency((Object)this.tracers.getPageCacheTracer());
        this.collectionsFactorySupplier = GlobalModule.createCollectionsFactorySupplier(globalConfig, this.globalLife);
        this.ioControllerService = GlobalModule.loadIOControllerService();
        this.pageCache = this.tryResolveOrCreate(PageCache.class, () -> this.createPageCache(this.fileSystem, globalConfig, this.logService, this.tracers, this.jobScheduler, this.globalClock, this.memoryPools));
        this.globalLife.add((Lifecycle)new PageCacheLifecycle(this.pageCache));
        this.dbmsDiagnosticsManager = new DbmsDiagnosticsManager(this.globalDependencies, this.logService);
        this.globalDependencies.satisfyDependency((Object)this.dbmsDiagnosticsManager);
        this.dbmsDiagnosticsManager.dumpSystemDiagnostics();
        this.fileSystemWatcher = this.createFileSystemWatcherService(this.fileSystem, this.logService, this.jobScheduler, globalConfig);
        this.globalLife.add((Lifecycle)this.fileSystemWatcher);
        this.globalDependencies.satisfyDependency((Object)this.fileSystemWatcher);
        this.extensionFactories = externalDependencies.extensions();
        this.globalExtensions = (GlobalExtensions)this.globalDependencies.satisfyDependency((Object)new GlobalExtensions(new GlobalExtensionContext(this.neo4jLayout, dbmsInfo, (DependencySatisfier)this.globalDependencies), this.extensionFactories, this.globalDependencies, ExtensionFailureStrategies.fail()));
        this.globalDependencies.satisfyDependency((Object)URLAccessRules.combined(externalDependencies.urlAccessRules()));
        this.databaseEventListeners = new DatabaseEventListeners(this.logService.getInternalLog(DatabaseEventListeners.class));
        Iterable<DatabaseEventListener> externalListeners = externalDependencies.databaseEventListeners();
        for (DatabaseEventListener databaseListener : externalListeners) {
            this.databaseEventListeners.registerDatabaseEventListener(databaseListener);
        }
        this.globalDependencies.satisfyDependencies(new Object[]{this.databaseEventListeners});
        this.transactionEventListeners = new GlobalTransactionEventListeners();
        this.globalDependencies.satisfyDependency((Object)this.transactionEventListeners);
        this.connectorPortRegister = new ConnectorPortRegister();
        this.globalDependencies.satisfyDependency((Object)this.connectorPortRegister);
        this.transactionManager = new StatementProcessorTxManager();
        this.capabilitiesService = this.loadCapabilities();
        this.globalDependencies.satisfyDependency((Object)this.capabilitiesService);
        this.globalDependencies.satisfyDependency((Object)this.tryResolveOrCreate(NativeAccess.class, NativeAccessProvider::getNativeAccess));
        this.checkLegacyDefaultDatabase();
    }

    private <T> T tryResolveOrCreate(Class<T> clazz, Supplier<T> newInstanceMethod) {
        return (T)(this.externalDependencyResolver.containsDependency(clazz) ? this.externalDependencyResolver.resolveDependency(clazz) : newInstanceMethod.get());
    }

    private void checkLegacyDefaultDatabase() {
        if (!this.globalConfig.isExplicitlySet(GraphDatabaseSettings.default_database)) {
            DatabaseLayout defaultDatabaseLayout;
            StorageEngineFactory storageEngineFactory = StorageEngineFactory.defaultStorageEngine();
            if (storageEngineFactory.storageExists(this.fileSystem, defaultDatabaseLayout = this.neo4jLayout.databaseLayout((String)this.globalConfig.get(GraphDatabaseSettings.default_database)), this.pageCache)) {
                return;
            }
            String legacyDatabaseName = "graph.db";
            DatabaseLayout legacyDatabaseLayout = this.neo4jLayout.databaseLayout("graph.db");
            if (storageEngineFactory.storageExists(this.fileSystem, legacyDatabaseLayout, this.pageCache)) {
                Log internalLog = this.logService.getInternalLog(this.getClass());
                this.globalConfig.set(GraphDatabaseSettings.default_database, (Object)"graph.db");
                internalLog.warn("Legacy `%s` database was found and default database was set to point to into it. Please consider setting default database explicitly.", new Object[]{"graph.db"});
            }
        }
    }

    protected FileLockerService createFileLockerService() {
        return new GlobalLockerService();
    }

    protected SystemNanoClock createClock() {
        return Clocks.nanoClock();
    }

    public LifeSupport createLife() {
        return new LifeSupport();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    private FileSystemWatcherService createFileSystemWatcherService(FileSystemAbstraction fileSystem, LogService logging, JobScheduler jobScheduler, Config config) {
        if (!((Boolean)config.get(GraphDatabaseSettings.filewatcher_enabled)).booleanValue()) {
            Log log = logging.getInternalLog(this.getClass());
            log.info("File watcher disabled by configuration.");
            return FileSystemWatcherService.EMPTY_WATCHER;
        }
        try {
            return new DefaultFileSystemWatcherService(jobScheduler, fileSystem.fileWatcher());
        }
        catch (Exception e) {
            Log log = logging.getInternalLog(this.getClass());
            log.warn("Can not create file watcher for current file system. File monitoring capabilities for store files will be disabled.", (Throwable)e);
            return FileSystemWatcherService.EMPTY_WATCHER;
        }
    }

    protected LogService createLogService(LogProvider userLogProvider) {
        Neo4jLoggerContext loggerContext = LogConfig.createBuilder((FileSystemAbstraction)this.fileSystem, (Path)((Path)this.globalConfig.get(GraphDatabaseSettings.store_internal_log_path)), (Level)((Level)this.globalConfig.get(GraphDatabaseSettings.store_internal_log_level))).withFormat((FormattedLogFormat)this.globalConfig.get(GraphDatabaseSettings.store_internal_log_format)).withTimezone((LogTimeZone)this.globalConfig.get(GraphDatabaseSettings.db_timezone)).withHeaderLogger(log -> this.dbmsDiagnosticsManager.dumpAll(log), DiagnosticsManager.class.getCanonicalName()).withRotation(((Long)this.globalConfig.get(GraphDatabaseSettings.store_internal_log_rotation_threshold)).longValue(), ((Integer)this.globalConfig.get(GraphDatabaseSettings.store_internal_log_max_archives)).intValue()).build();
        Log4jLogProvider internalLogProvider = new Log4jLogProvider(loggerContext);
        userLogProvider = userLogProvider == null ? NullLogProvider.getInstance() : userLogProvider;
        SimpleLogService logService = new SimpleLogService(userLogProvider, (LogProvider)internalLogProvider);
        this.globalConfig.addListener(GraphDatabaseSettings.store_internal_log_level, (before, after) -> internalLogProvider.updateLogLevel(after));
        if (userLogProvider instanceof Log4jLogProvider) {
            Log4jLogProvider provider = (Log4jLogProvider)userLogProvider;
            provider.updateLogLevel((Level)this.globalConfig.get(GraphDatabaseSettings.store_internal_log_level));
            this.globalConfig.addListener(GraphDatabaseSettings.store_internal_log_level, (before, after) -> provider.updateLogLevel(after));
        }
        return (LogService)this.globalLife.add((Lifecycle)logService);
    }

    private JobScheduler createJobScheduler() {
        JobScheduler jobScheduler = JobSchedulerFactory.createInitialisedScheduler((SystemNanoClock)this.globalClock);
        jobScheduler.setParallelism(Group.INDEX_SAMPLING, ((Integer)this.globalConfig.get(GraphDatabaseInternalSettings.index_sampling_parallelism)).intValue());
        jobScheduler.setParallelism(Group.INDEX_POPULATION, ((Integer)this.globalConfig.get(GraphDatabaseInternalSettings.index_population_parallelism)).intValue());
        jobScheduler.setParallelism(Group.PAGE_CACHE_PRE_FETCHER, ((Integer)this.globalConfig.get(GraphDatabaseSettings.pagecache_scan_prefetch)).intValue());
        return jobScheduler;
    }

    protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, JobScheduler jobScheduler, SystemNanoClock clock, MemoryPools memoryPools) {
        Log pageCacheLog = logging.getInternalLog(PageCache.class);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, config, tracers.getPageCacheTracer(), pageCacheLog, jobScheduler, clock, memoryPools);
        PageCache pageCache = pageCacheFactory.getOrCreatePageCache();
        if (((Boolean)config.get(GraphDatabaseInternalSettings.dump_configuration)).booleanValue()) {
            pageCacheFactory.dumpConfiguration();
        }
        return pageCache;
    }

    private static CollectionsFactorySupplier createCollectionsFactorySupplier(Config config, LifeSupport life) {
        GraphDatabaseSettings.TransactionStateMemoryAllocation allocation = (GraphDatabaseSettings.TransactionStateMemoryAllocation)config.get(GraphDatabaseSettings.tx_state_memory_allocation);
        switch (allocation) {
            case ON_HEAP: {
                return CollectionsFactorySupplier.ON_HEAP;
            }
            case OFF_HEAP: {
                CachingOffHeapBlockAllocator allocator = new CachingOffHeapBlockAllocator(((Long)config.get(GraphDatabaseSettings.tx_state_off_heap_max_cacheable_block_size)).longValue(), ((Integer)config.get(GraphDatabaseSettings.tx_state_off_heap_block_cache_size)).intValue());
                long maxMemory = (Long)config.get(GraphDatabaseSettings.tx_state_max_off_heap_memory);
                Object sharedBlockAllocator = maxMemory > 0L ? new CapacityLimitingBlockAllocatorDecorator((OffHeapBlockAllocator)allocator, maxMemory) : allocator;
                life.add(LifecycleAdapter.onShutdown(() -> ((OffHeapBlockAllocator)sharedBlockAllocator).release()));
                return () -> GlobalModule.lambda$createCollectionsFactorySupplier$5((OffHeapBlockAllocator)sharedBlockAllocator);
            }
        }
        throw new IllegalArgumentException("Unknown transaction state memory allocation value: " + allocation);
    }

    private CentralBufferMangerHolder crateCentralBufferManger() {
        if (!((Boolean)this.globalConfig.get(GraphDatabaseInternalSettings.managed_network_buffers)).booleanValue()) {
            return CentralBufferMangerHolder.EMPTY;
        }
        NeoByteBufferPool bufferPool = new NeoByteBufferPool(this.memoryPools, this.jobScheduler);
        this.globalLife.add((Lifecycle)bufferPool);
        NettyMemoryManagerWrapper nettyAllocator = new NettyMemoryManagerWrapper((ByteBufferManger)bufferPool);
        return new CentralBufferMangerHolder((ByteBufAllocator)nettyAllocator, (ByteBufferManger)bufferPool);
    }

    private static IOControllerService loadIOControllerService() {
        return (IOControllerService)Services.loadByPriority(IOControllerService.class).orElseThrow(() -> new IllegalStateException(IOControllerService.class.getSimpleName() + " not found."));
    }

    private CapabilitiesService loadCapabilities() {
        CapabilitiesService service = CapabilitiesService.newCapabilities((Configuration)this.globalConfig, (DependencyResolver)this.globalDependencies);
        service.set(DBMSCapabilities.dbms_instance_version, (Object)Version.getNeo4jVersion());
        service.set(DBMSCapabilities.dbms_instance_kernel_version, (Object)Version.getKernelVersion());
        service.set(DBMSCapabilities.dbms_instance_edition, (Object)this.dbmsInfo.edition.toString());
        service.set(DBMSCapabilities.dbms_instance_operational_mode, (Object)this.dbmsInfo.operationalMode.toString());
        return service;
    }

    public FileWatcher getFileWatcher() {
        return this.fileSystemWatcher.getFileWatcher();
    }

    public ConnectorPortRegister getConnectorPortRegister() {
        return this.connectorPortRegister;
    }

    CollectionsFactorySupplier getCollectionsFactorySupplier() {
        return this.collectionsFactorySupplier;
    }

    public SystemNanoClock getGlobalClock() {
        return this.globalClock;
    }

    public JobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public GlobalExtensions getGlobalExtensions() {
        return this.globalExtensions;
    }

    Iterable<ExtensionFactory<?>> getExtensionFactories() {
        return this.extensionFactories;
    }

    public Config getGlobalConfig() {
        return this.globalConfig;
    }

    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    public Tracers getTracers() {
        return this.tracers;
    }

    public Neo4jLayout getNeo4jLayout() {
        return this.neo4jLayout;
    }

    public DbmsInfo getDbmsInfo() {
        return this.dbmsInfo;
    }

    public LifeSupport getGlobalLife() {
        return this.globalLife;
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public Monitors getGlobalMonitors() {
        return this.globalMonitors;
    }

    public Dependencies getGlobalDependencies() {
        return this.globalDependencies;
    }

    public LogService getLogService() {
        return this.logService;
    }

    public CompositeDatabaseAvailabilityGuard getGlobalAvailabilityGuard() {
        return this.globalAvailabilityGuard;
    }

    public DatabaseEventListeners getDatabaseEventListeners() {
        return this.databaseEventListeners;
    }

    public GlobalTransactionEventListeners getTransactionEventListeners() {
        return this.transactionEventListeners;
    }

    public DependencyResolver getExternalDependencyResolver() {
        return this.externalDependencyResolver;
    }

    FileLockerService getFileLockerService() {
        return this.fileLockerService;
    }

    public MemoryPools getMemoryPools() {
        return this.memoryPools;
    }

    public GlobalMemoryGroupTracker getTransactionsMemoryPool() {
        return this.transactionsMemoryPool;
    }

    public GlobalMemoryGroupTracker getOtherMemoryPool() {
        return this.otherMemoryPool;
    }

    public SystemGraphComponents getSystemGraphComponents() {
        return this.systemGraphComponents;
    }

    public CentralBufferMangerHolder getCentralBufferMangerHolder() {
        return this.centralBufferMangerHolder;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public IOControllerService getIoControllerService() {
        return this.ioControllerService;
    }

    public CapabilitiesService getCapabilitiesService() {
        return this.capabilitiesService;
    }

    private static /* synthetic */ CollectionsFactory lambda$createCollectionsFactorySupplier$5(OffHeapBlockAllocator sharedBlockAllocator) {
        return new OffHeapCollectionsFactory(sharedBlockAllocator);
    }
}

