/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition.context;

import java.util.function.Function;
import org.neo4j.graphdb.factory.module.edition.StandaloneEditionModule;
import org.neo4j.graphdb.factory.module.edition.context.EditionDatabaseComponents;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ExternalIdReuseConditionProvider;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.token.TokenHolders;

public class StandaloneDatabaseComponents
implements EditionDatabaseComponents {
    private final Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    private final ConstraintSemantics constraintSemantics;
    private final CommitProcessFactory commitProcessFactory;
    private final TokenHolders tokenHolders;
    private final Locks locks;
    private final DatabaseTransactionStats transactionMonitor;
    private final DatabaseIdContext idContext;
    private final QueryEngineProvider queryEngineProvider;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final DatabaseStartupController startupController;

    public StandaloneDatabaseComponents(StandaloneEditionModule editionModule, NamedDatabaseId namedDatabaseId) {
        this.commitProcessFactory = editionModule.getCommitProcessFactory();
        this.constraintSemantics = editionModule.getConstraintSemantics();
        this.watcherServiceFactory = editionModule.getWatcherServiceFactory();
        this.idContext = editionModule.getIdContextFactory().createIdContext(namedDatabaseId);
        this.tokenHolders = editionModule.getTokenHoldersProvider().apply(namedDatabaseId);
        this.locks = editionModule.getLocksSupplier().get();
        this.transactionMonitor = editionModule.createTransactionMonitor();
        this.queryEngineProvider = editionModule.getQueryEngineProvider();
        this.startupController = editionModule.getDatabaseStartupController();
        this.accessCapabilityFactory = AccessCapabilityFactory.configDependent();
    }

    @Override
    public DatabaseIdContext getIdContext() {
        return this.idContext;
    }

    @Override
    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    @Override
    public Function<DatabaseLayout, DatabaseLayoutWatcher> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    @Override
    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    @Override
    public CommitProcessFactory getCommitProcessFactory() {
        return this.commitProcessFactory;
    }

    @Override
    public Locks getLocks() {
        return this.locks;
    }

    @Override
    public DatabaseTransactionStats getTransactionMonitor() {
        return this.transactionMonitor;
    }

    @Override
    public QueryEngineProvider getQueryEngineProvider() {
        return this.queryEngineProvider;
    }

    @Override
    public AccessCapabilityFactory getAccessCapabilityFactory() {
        return this.accessCapabilityFactory;
    }

    @Override
    public DatabaseStartupController getStartupController() {
        return this.startupController;
    }

    @Override
    public ExternalIdReuseConditionProvider getExternalIdReuseConditionProvider() {
        return ExternalIdReuseConditionProvider.NONE;
    }
}

