/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.id;

import java.util.Objects;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.id.DefaultIdGeneratorFactory;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.scheduler.JobScheduler;

public final class IdContextFactoryBuilder {
    private FileSystemAbstraction fileSystemAbstraction;
    private JobScheduler jobScheduler;
    private Function<NamedDatabaseId, IdGeneratorFactory> idGeneratorFactoryProvider;
    private Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper;
    private Config config;
    private PageCacheTracer cacheTracer;

    private IdContextFactoryBuilder() {
    }

    public static IdContextFactoryBuilder of(FileSystemAbstraction fileSystemAbstraction, JobScheduler jobScheduler, Config config, PageCacheTracer cacheTracer) {
        IdContextFactoryBuilder builder = new IdContextFactoryBuilder();
        builder.fileSystemAbstraction = fileSystemAbstraction;
        builder.jobScheduler = jobScheduler;
        builder.config = config;
        builder.cacheTracer = cacheTracer;
        return builder;
    }

    public IdContextFactoryBuilder withIdGenerationFactoryProvider(Function<NamedDatabaseId, IdGeneratorFactory> idGeneratorFactoryProvider) {
        this.idGeneratorFactoryProvider = idGeneratorFactoryProvider;
        return this;
    }

    public IdContextFactoryBuilder withFactoryWrapper(Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper) {
        this.factoryWrapper = factoryWrapper;
        return this;
    }

    public IdContextFactory build() {
        if (this.idGeneratorFactoryProvider == null) {
            Objects.requireNonNull(this.fileSystemAbstraction, "File system is required to build id generator factory.");
            this.idGeneratorFactoryProvider = IdContextFactoryBuilder.defaultIdGeneratorFactoryProvider(this.fileSystemAbstraction, this.config);
        }
        if (this.factoryWrapper == null) {
            this.factoryWrapper = Function.identity();
        }
        return new IdContextFactory(this.jobScheduler, this.idGeneratorFactoryProvider, this.factoryWrapper, this.cacheTracer);
    }

    public static Function<NamedDatabaseId, IdGeneratorFactory> defaultIdGeneratorFactoryProvider(FileSystemAbstraction fs, Config config) {
        return databaseId -> {
            boolean allowLargeIdCaches = (Boolean)config.get(GraphDatabaseInternalSettings.force_small_id_cache) == false;
            return new DefaultIdGeneratorFactory(fs, RecoveryCleanupWorkCollector.immediate(), allowLargeIdCaches, databaseId.name());
        };
    }
}

