/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.neo4j.cli.AdminTool;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.BootloaderCommand;
import org.neo4j.server.startup.BootloaderContext;
import org.neo4j.server.startup.VerboseCommand;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="Neo4j Admin", description={"Neo4j Admin CLI."})
class Neo4jAdminCommand
extends BootloaderCommand
implements Callable<Integer>,
VerboseCommand {
    @CommandLine.Parameters(hidden=true)
    private List<String> allParameters = List.of();
    @CommandLine.Option(names={"--expand-commands"}, hidden=true, description={"Allow command expansion in config value evaluation."})
    boolean expandCommands;
    @CommandLine.Option(names={"--verbose"}, hidden=true, description={"Prints additional information."})
    boolean verbose;

    Neo4jAdminCommand(Neo4jAdminBootloaderContext ctx) {
        super(ctx);
    }

    static CommandLine asCommandLine(Neo4jAdminBootloaderContext ctx) {
        return Neo4jAdminCommand.addDefaultOptions(new CommandLine((Object)new Neo4jAdminCommand(ctx)), ctx).setUnmatchedArgumentsAllowed(true).setUnmatchedOptionsArePositionalParams(true).setExpandAtFiles(false);
    }

    @Override
    public Integer call() throws Exception {
        String[] args = this.allParameters.toArray(new String[0]);
        this.ctx.init(this.expandCommands, this.verbose, args);
        CommandLine actualAdminCommand = AdminTool.getCommandLine((ExecutionContext)new ExecutionContext(this.ctx.home(), this.ctx.confDir(), this.ctx.out, this.ctx.err, (FileSystemAbstraction)new DefaultFileSystemAbstraction()));
        if (this.allParameters.isEmpty()) {
            actualAdminCommand.usage(this.ctx.out);
            return 2;
        }
        try {
            CommandLine.ParseResult result = actualAdminCommand.parseArgs(args);
            Integer code = CommandLine.executeHelpRequest((CommandLine.ParseResult)result);
            if (code != null) {
                return code;
            }
        }
        catch (CommandLine.ParameterException e) {
            return e.getCommandLine().getParameterExceptionHandler().handleParseException(e, args);
        }
        Bootloader bootloader = new Bootloader(this.ctx);
        return bootloader.admin();
    }

    public static void main(String[] args) {
        int exitCode = Neo4jAdminCommand.asCommandLine(new Neo4jAdminBootloaderContext()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }

    static class Neo4jAdminBootloaderContext
    extends BootloaderContext {
        private static final Class<?> entrypoint = AdminTool.class;

        Neo4jAdminBootloaderContext() {
            super(entrypoint);
        }

        @VisibleForTesting
        Neo4jAdminBootloaderContext(PrintStream out, PrintStream err, Function<String, String> envLookup, Function<String, String> propLookup, Runtime.Version version) {
            super(out, err, envLookup, propLookup, entrypoint, version);
        }

        @Override
        void init(boolean expandCommands, boolean verbose, String ... additionalArgs) {
            super.init(expandCommands, verbose, additionalArgs);
            if (verbose) {
                this.additionalArgs.add("--verbose");
            }
        }

        @Override
        protected Map<Setting<?>, Object> overriddenDefaultsValues() {
            return Map.of(BootloaderSettings.additional_jvm, "-XX:+UseParallelGC");
        }
    }
}

