/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler;

import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.compiler.StatsDivergenceCalculator;
import org.neo4j.cypher.internal.compiler.StatsDivergenceExponentialDecayCalculator;
import org.neo4j.cypher.internal.compiler.StatsDivergenceInverseDecayCalculator;
import org.neo4j.cypher.internal.compiler.StatsDivergenceNoDecayCalculator;
import org.neo4j.cypher.internal.config.StatsDivergenceCalculatorConfig;
import scala.MatchError;
import scala.Tuple5;
import scala.runtime.BoxesRunTime;

public final class StatsDivergenceCalculator$ {
    public static StatsDivergenceCalculator$ MODULE$;
    private final double similarityTolerance;

    static {
        new StatsDivergenceCalculator$();
    }

    public double similarityTolerance() {
        return this.similarityTolerance;
    }

    public StatsDivergenceCalculator divergenceCalculatorFor(StatsDivergenceCalculatorConfig config) {
        StatsDivergenceCalculatorConfig statsDivergenceCalculatorConfig = config;
        if (statsDivergenceCalculatorConfig == null) {
            throw new MatchError((Object)statsDivergenceCalculatorConfig);
        }
        GraphDatabaseInternalSettings.CypherReplanAlgorithm algorithm = statsDivergenceCalculatorConfig.algorithm();
        double initialThreshold = statsDivergenceCalculatorConfig.initialThreshold();
        double targetThreshold = statsDivergenceCalculatorConfig.targetThreshold();
        long minReplanInterval = statsDivergenceCalculatorConfig.minReplanInterval();
        long targetReplanInterval = statsDivergenceCalculatorConfig.targetReplanInterval();
        Tuple5 tuple5 = new Tuple5((Object)algorithm, (Object)BoxesRunTime.boxToDouble((double)initialThreshold), (Object)BoxesRunTime.boxToDouble((double)targetThreshold), (Object)BoxesRunTime.boxToLong((long)minReplanInterval), (Object)BoxesRunTime.boxToLong((long)targetReplanInterval));
        Tuple5 tuple52 = tuple5;
        GraphDatabaseInternalSettings.CypherReplanAlgorithm algorithm2 = (GraphDatabaseInternalSettings.CypherReplanAlgorithm)tuple52._1();
        double initialThreshold2 = BoxesRunTime.unboxToDouble((Object)tuple52._2());
        double targetThreshold2 = BoxesRunTime.unboxToDouble((Object)tuple52._3());
        long minReplanInterval2 = BoxesRunTime.unboxToLong((Object)tuple52._4());
        long targetReplanInterval2 = BoxesRunTime.unboxToLong((Object)tuple52._5());
        return this.divergenceCalculatorFor(algorithm2, initialThreshold2, targetThreshold2, minReplanInterval2, targetReplanInterval2);
    }

    public StatsDivergenceCalculator divergenceCalculatorFor(GraphDatabaseInternalSettings.CypherReplanAlgorithm algorithm, double initialThreshold, double targetThreshold, long minReplanInterval, long targetReplanInterval) {
        StatsDivergenceNoDecayCalculator statsDivergenceNoDecayCalculator;
        if (targetThreshold <= this.similarityTolerance() || initialThreshold - targetThreshold <= this.similarityTolerance() || targetReplanInterval <= minReplanInterval) {
            statsDivergenceNoDecayCalculator = new StatsDivergenceNoDecayCalculator(initialThreshold, minReplanInterval);
        } else {
            StatsDivergenceCalculator statsDivergenceCalculator;
            GraphDatabaseInternalSettings.CypherReplanAlgorithm cypherReplanAlgorithm = algorithm;
            if (GraphDatabaseInternalSettings.CypherReplanAlgorithm.NONE.equals(cypherReplanAlgorithm)) {
                statsDivergenceCalculator = new StatsDivergenceNoDecayCalculator(initialThreshold, minReplanInterval);
            } else if (GraphDatabaseInternalSettings.CypherReplanAlgorithm.EXPONENTIAL.equals(cypherReplanAlgorithm)) {
                statsDivergenceCalculator = new StatsDivergenceExponentialDecayCalculator(initialThreshold, targetThreshold, minReplanInterval, targetReplanInterval);
            } else {
                boolean bl = GraphDatabaseInternalSettings.CypherReplanAlgorithm.INVERSE.equals(cypherReplanAlgorithm) ? true : GraphDatabaseInternalSettings.CypherReplanAlgorithm.DEFAULT.equals(cypherReplanAlgorithm);
                if (bl) {
                    statsDivergenceCalculator = new StatsDivergenceInverseDecayCalculator(initialThreshold, targetThreshold, minReplanInterval, targetReplanInterval);
                } else {
                    throw new MatchError((Object)cypherReplanAlgorithm);
                }
            }
            statsDivergenceNoDecayCalculator = statsDivergenceCalculator;
        }
        return statsDivergenceNoDecayCalculator;
    }

    public StatsDivergenceNoDecayCalculator divergenceNoDecayCalculator(double threshold, long ttl) {
        return new StatsDivergenceNoDecayCalculator(threshold, ttl);
    }

    private StatsDivergenceCalculator$() {
        MODULE$ = this;
        this.similarityTolerance = 1.0E-4;
    }
}

