/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.lambda.LoopTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.RepeatStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.DedupGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.LoopsStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.NoOpBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.LazyBarrierStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class RepeatUnrollStrategy
extends AbstractTraversalStrategy<TraversalStrategy.OptimizationStrategy>
implements TraversalStrategy.OptimizationStrategy {
    private static final RepeatUnrollStrategy INSTANCE = new RepeatUnrollStrategy();
    protected static final int MAX_BARRIER_SIZE = 2500;
    private static final Set<Class> INVALIDATING_STEPS = new HashSet<Class>(Arrays.asList(LambdaHolder.class, LoopsStep.class));

    private RepeatUnrollStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (TraversalHelper.onGraphComputer(traversal)) {
            return;
        }
        boolean lazyBarrierStrategyInstalled = TraversalHelper.getRootTraversal(traversal).getStrategies().getStrategy(LazyBarrierStrategy.class).isPresent();
        for (int i = 0; i < traversal.getSteps().size(); ++i) {
            RepeatStep repeatStep;
            if (!(traversal.getSteps().get(i) instanceof RepeatStep) || null != (repeatStep = (RepeatStep)traversal.getSteps().get(i)).getEmitTraversal() || null == repeatStep.getRepeatTraversal() || !(repeatStep.getUntilTraversal() instanceof LoopTraversal) || ((LoopTraversal)repeatStep.getUntilTraversal()).getMaxLoops() <= 0L || TraversalHelper.hasStepOfAssignableClassRecursively(Scope.global, DedupGlobalStep.class, repeatStep.getRepeatTraversal()) || TraversalHelper.hasStepOfAssignableClassRecursively(INVALIDATING_STEPS, repeatStep.getRepeatTraversal())) continue;
            Traversal.Admin repeatTraversal = repeatStep.getGlobalChildren().get(0);
            repeatTraversal.removeStep(repeatTraversal.getSteps().size() - 1);
            TraversalHelper.applySingleLevelStrategies(traversal, repeatTraversal, RepeatUnrollStrategy.class);
            int repeatLength = repeatTraversal.getSteps().size();
            int insertIndex = i;
            int loops = (int)((LoopTraversal)repeatStep.getUntilTraversal()).getMaxLoops();
            for (int j = 0; j < loops; ++j) {
                TraversalHelper.insertTraversal(insertIndex, repeatTraversal.clone(), traversal);
                insertIndex += repeatLength;
                if (!lazyBarrierStrategyInstalled) continue;
                Step step = traversal.getSteps().get(insertIndex);
                if (j == loops - 1 && step.getNextStep() instanceof Barrier || step instanceof NoOpBarrierStep) continue;
                traversal.addStep(++insertIndex, new NoOpBarrierStep(traversal, 2500));
            }
            if (!repeatStep.getLabels().isEmpty()) {
                TraversalHelper.copyLabels(repeatStep, traversal.getSteps().get(insertIndex), false);
            }
            traversal.removeStep(i);
        }
    }

    public static RepeatUnrollStrategy instance() {
        return INSTANCE;
    }
}

