/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.eval;

import java.util.Optional;
import org.neo4j.fabric.eval.DatabaseLookup$;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import scala.Option;
import scala.Option$;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.SortedSet;
import scala.collection.SortedSet$;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4q!\u0005\n\u0011\u0002G\u00051\u0004C\u0003#\u0001\u0019\u00051\u0005C\u00038\u0001\u0019\u0005\u0001\bC\u0003>\u0001\u0019\u0005ahB\u0003E%!\u0005QIB\u0003\u0012%!\u0005q\tC\u0003I\u000b\u0011\u0005\u0011\nC\u0004K\u000b\t\u0007I1A&\t\ra+\u0001\u0015!\u0003M\u0011\u001dIVA1A\u0005\u0004iCa\u0001X\u0003!\u0002\u0013Yf\u0001B/\u0006\u0001yC\u0001\u0002Y\u0006\u0003\u0002\u0003\u0006I!\u0019\u0005\u0006\u0011.!\t\u0001\u001a\u0005\u0006E-!\ta\t\u0005\u0006o-!\t\u0001\u000f\u0005\u0006{-!\t\u0001\u001b\u0002\u000f\t\u0006$\u0018MY1tK2{wn[;q\u0015\t\u0019B#\u0001\u0003fm\u0006d'BA\u000b\u0017\u0003\u00191\u0017M\u0019:jG*\u0011q\u0003G\u0001\u0006]\u0016|GG\u001b\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002%\u0011\fG/\u00192bg\u0016\u0014VMZ3sK:\u001cWm]\u000b\u0002IA!QE\u000b\u00175\u001b\u00051#BA\u0014)\u0003%IW.\\;uC\ndWM\u0003\u0002*=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005-2#!C*peR,G-T1q!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0005eCR\f'-Y:f\u0015\t\td#\u0001\u0004lKJtW\r\\\u0005\u0003g9\u0012aCT8s[\u0006d\u0017N_3e\t\u0006$\u0018MY1tK:\u000bW.\u001a\t\u0003[UJ!A\u000e\u0018\u0003\u001f9\u000bW.\u001a3ECR\f'-Y:f\u0013\u0012\f1\u0002Z1uC\n\f7/Z%egV\t\u0011\bE\u0002;wQj\u0011\u0001K\u0005\u0003y!\u0012\u0011bU8si\u0016$7+\u001a;\u0002\u0015\u0011\fG/\u00192bg\u0016LE\r\u0006\u0002@\u0005B\u0019Q\u0004\u0011\u001b\n\u0005\u0005s\"AB(qi&|g\u000eC\u0003D\u0007\u0001\u0007A&\u0001\u0007eCR\f'-Y:f\u001d\u0006lW-\u0001\bECR\f'-Y:f\u0019>|7.\u001e9\u0011\u0005\u0019+Q\"\u0001\n\u0014\u0005\u0015a\u0012A\u0002\u001fj]&$h\bF\u0001F\u0003Q!\u0017\r^1cCN,g*Y7f\u001fJ$WM]5oOV\tA\nE\u0002N+2r!AT*\u000f\u0005=\u0013V\"\u0001)\u000b\u0005ES\u0012A\u0002\u001fs_>$h(C\u0001 \u0013\t!f$A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005Qs\u0012!\u00063bi\u0006\u0014\u0017m]3OC6,wJ\u001d3fe&tw\rI\u0001\u0013I\u0006$\u0018MY1tK&#wJ\u001d3fe&tw-F\u0001\\!\riU\u000bN\u0001\u0014I\u0006$\u0018MY1tK&#wJ\u001d3fe&tw\r\t\u0002\b\t\u00164\u0017-\u001e7u'\rYAd\u0018\t\u0003\r\u0002\tA\u0003Z1uC\n\f7/Z%e%\u0016\u0004xn]5u_JL\bCA\u0017c\u0013\t\u0019gF\u0001\u000bECR\f'-Y:f\u0013\u0012\u0014V\r]8tSR|'/\u001f\u000b\u0003K\u001e\u0004\"AZ\u0006\u000e\u0003\u0015AQ\u0001Y\u0007A\u0002\u0005$\"aP5\t\u000b\r\u0003\u0002\u0019\u0001\u0017")
public interface DatabaseLookup {
    public static Ordering<NamedDatabaseId> databaseIdOrdering() {
        return DatabaseLookup$.MODULE$.databaseIdOrdering();
    }

    public static Ordering<NormalizedDatabaseName> databaseNameOrdering() {
        return DatabaseLookup$.MODULE$.databaseNameOrdering();
    }

    public SortedMap<NormalizedDatabaseName, NamedDatabaseId> databaseReferences();

    public SortedSet<NamedDatabaseId> databaseIds();

    public Option<NamedDatabaseId> databaseId(NormalizedDatabaseName var1);

    public static class Default
    implements DatabaseLookup {
        private final DatabaseIdRepository databaseIdRepository;

        @Override
        public SortedMap<NormalizedDatabaseName, NamedDatabaseId> databaseReferences() {
            Map unsortedMap = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.databaseIdRepository.getAllDatabaseAliases()).asScala();
            return SortedMap$.MODULE$.empty(DatabaseLookup$.MODULE$.databaseNameOrdering()).$plus$plus((GenTraversableOnce)unsortedMap);
        }

        @Override
        public SortedSet<NamedDatabaseId> databaseIds() {
            Set unsortedSet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(this.databaseIdRepository.getAllDatabaseIds()).asScala();
            return (SortedSet)SortedSet$.MODULE$.empty(DatabaseLookup$.MODULE$.databaseIdOrdering()).$plus$plus((GenTraversableOnce)unsortedSet);
        }

        @Override
        public Option<NamedDatabaseId> databaseId(NormalizedDatabaseName databaseName) {
            Optional maybeDatabaseId = this.databaseIdRepository.getByName(databaseName);
            return Option$.MODULE$.apply(maybeDatabaseId.get());
        }

        public Default(DatabaseIdRepository databaseIdRepository) {
            this.databaseIdRepository = databaseIdRepository;
        }
    }
}

