/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation;

import java.io.Serializable;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.AggregationFunction;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingDurations$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.NumericOrDurationAggregationExpression$AggregatingNumbers$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.aggregation.SumFunction$;
import org.neo4j.exceptions.InternalException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.utils.ValueMath;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%4A\u0001D\u0007\u0001=!Aa\u0005\u0001BC\u0002\u0013\u0005q\u0005\u0003\u00051\u0001\t\u0005\t\u0015!\u0003)\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015i\u0005\u0001\"\u0011O\u000f\u0015aV\u0002#\u0001^\r\u0015aQ\u0002#\u0001_\u0011\u0015\t\u0004\u0002\"\u0001c\u0011\u001d\u0019\u0007B1A\u0005\u0002\u0011Da\u0001\u001b\u0005!\u0002\u0013)'aC*v[\u001a+hn\u0019;j_:T!AD\b\u0002\u0017\u0005<wM]3hCRLwN\u001c\u0006\u0003!E\tQ\u0001]5qKNT!AE\n\u0002\u0017%tG/\u001a:qe\u0016$X\r\u001a\u0006\u0003)U\tqA];oi&lWM\u0003\u0002\u0017/\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u00193\u000511-\u001f9iKJT!AG\u000e\u0002\u000b9,w\u000e\u000e6\u000b\u0003q\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0010$!\t\u0001\u0013%D\u0001\u000e\u0013\t\u0011SBA\nBO\u001e\u0014XmZ1uS>tg)\u001e8di&|g\u000e\u0005\u0002!I%\u0011Q%\u0004\u0002'\u001dVlWM]5d\u001fJ$UO]1uS>t\u0017iZ4sK\u001e\fG/[8o\u000bb\u0004(/Z:tS>t\u0017!\u0002<bYV,W#\u0001\u0015\u0011\u0005%rS\"\u0001\u0016\u000b\u0005-b\u0013aC3yaJ,7o]5p]NT!!L\t\u0002\u0011\r|W.\\1oINL!a\f\u0016\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004wC2,X\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M\"\u0004C\u0001\u0011\u0001\u0011\u001513\u00011\u0001)\u0003\u0011q\u0017-\\3\u0016\u0003]\u0002\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\t1\fgn\u001a\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0004TiJLgnZ\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0015\u0005\u0005;\u0005C\u0001\"F\u001b\u0005\u0019%B\u0001#\u001a\u0003\u00191\u0018\r\\;fg&\u0011ai\u0011\u0002\t\u0003:Lh+\u00197vK\")\u0001*\u0002a\u0001\u0013\u0006)1\u000f^1uKB\u0011!jS\u0007\u0002\u001f%\u0011Aj\u0004\u0002\u000b#V,'/_*uCR,\u0017!B1qa2LHcA(V7B\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n!QK\\5u\u0011\u00151f\u00011\u0001X\u0003\u0011!\u0017\r^1\u0011\u0005aKV\"A\n\n\u0005i\u001b\"a\u0003*fC\u0012\f'\r\\3S_^DQ\u0001\u0013\u0004A\u0002%\u000b1bU;n\rVt7\r^5p]B\u0011\u0001\u0005C\n\u0003\u0011}\u0003\"\u0001\u00151\n\u0005\u0005\f&AB!osJ+g\rF\u0001^\u00031\u0019\u0006*\u0011'M\u001f^{6+\u0013.F+\u0005)\u0007C\u0001)g\u0013\t9\u0017K\u0001\u0003M_:<\u0017!D*I\u00032cujV0T\u0013j+\u0005\u0005")
public class SumFunction
extends AggregationFunction
implements NumericOrDurationAggregationExpression {
    private final Expression value;
    private volatile NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers$module;
    private volatile NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations$module;
    private NumberValue sumNumber;
    private DurationValue sumDuration;
    private Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType;

    public static long SHALLOW_SIZE() {
        return SumFunction$.MODULE$.SHALLOW_SIZE();
    }

    @Override
    public void actOnNumberOrDuration(AnyValue vl, Function1<NumberValue, BoxedUnit> aggNumber, Function1<DurationValue, BoxedUnit> aggDuration) {
        NumericOrDurationAggregationExpression.actOnNumberOrDuration$(this, vl, aggNumber, aggDuration);
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingNumbers$ AggregatingNumbers() {
        if (this.AggregatingNumbers$module == null) {
            this.AggregatingNumbers$lzycompute$1();
        }
        return this.AggregatingNumbers$module;
    }

    @Override
    public NumericOrDurationAggregationExpression$AggregatingDurations$ AggregatingDurations() {
        if (this.AggregatingDurations$module == null) {
            this.AggregatingDurations$lzycompute$1();
        }
        return this.AggregatingDurations$module;
    }

    @Override
    public NumberValue sumNumber() {
        return this.sumNumber;
    }

    @Override
    public void sumNumber_$eq(NumberValue x$1) {
        this.sumNumber = x$1;
    }

    @Override
    public DurationValue sumDuration() {
        return this.sumDuration;
    }

    @Override
    public void sumDuration_$eq(DurationValue x$1) {
        this.sumDuration = x$1;
    }

    @Override
    public Option<NumericOrDurationAggregationExpression.AggregatingType> aggregatingType() {
        return this.aggregatingType;
    }

    @Override
    public void aggregatingType_$eq(Option<NumericOrDurationAggregationExpression.AggregatingType> x$1) {
        this.aggregatingType = x$1;
    }

    @Override
    public Expression value() {
        return this.value;
    }

    @Override
    public String name() {
        return "SUM";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AnyValue result(QueryState state) {
        boolean bl = false;
        Some some = null;
        Option<NumericOrDurationAggregationExpression.AggregatingType> option = this.aggregatingType();
        if (None$.MODULE$.equals(option)) {
            return this.sumNumber();
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
            if (this.AggregatingNumbers().equals(aggregatingType)) {
                return this.sumNumber();
            }
        }
        if (!bl) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        NumericOrDurationAggregationExpression.AggregatingType aggregatingType = (NumericOrDurationAggregationExpression.AggregatingType)some.value();
        if (!this.AggregatingDurations().equals(aggregatingType)) throw new InternalException(new StringBuilder(25).append("invalid aggregation type ").append(this.aggregatingType()).toString());
        return this.sumDuration();
    }

    @Override
    public void apply(ReadableRow data, QueryState state) {
        AnyValue vl = this.value().apply(data, state);
        this.actOnNumberOrDuration(vl, (Function1<NumberValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)number -> {
            this.sumNumber_$eq(ValueMath.overflowSafeAdd((NumberValue)this.sumNumber(), (NumberValue)number));
            return BoxedUnit.UNIT;
        }, (Function1<DurationValue, BoxedUnit>)(Function1 & Serializable & scala.Serializable)duration -> {
            this.sumDuration_$eq(this.sumDuration().add(duration));
            return BoxedUnit.UNIT;
        });
    }

    private final void AggregatingNumbers$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingNumbers$module == null) {
                this.AggregatingNumbers$module = new NumericOrDurationAggregationExpression$AggregatingNumbers$(this);
            }
        }
    }

    private final void AggregatingDurations$lzycompute$1() {
        SumFunction sumFunction = this;
        synchronized (sumFunction) {
            if (this.AggregatingDurations$module == null) {
                this.AggregatingDurations$module = new NumericOrDurationAggregationExpression$AggregatingDurations$(this);
            }
        }
    }

    public SumFunction(Expression value) {
        this.value = value;
        NumericOrDurationAggregationExpression.$init$(this);
    }
}

