from typing import List, Optional, Dict, Iterable, Any, overload
import io
import collections.abc
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
import aspose.cells
import aspose.cells.charts
import aspose.cells.digitalsignatures
import aspose.cells.drawing
import aspose.cells.drawing.activexcontrols
import aspose.cells.drawing.equations
import aspose.cells.drawing.texts
import aspose.cells.externalconnections
import aspose.cells.json
import aspose.cells.markup
import aspose.cells.metadata
import aspose.cells.numbers
import aspose.cells.ods
import aspose.cells.pivot
import aspose.cells.properties
import aspose.cells.querytables
import aspose.cells.rendering
import aspose.cells.rendering.pdfsecurity
import aspose.cells.revisions
import aspose.cells.saving
import aspose.cells.settings
import aspose.cells.slicers
import aspose.cells.slides
import aspose.cells.tables
import aspose.cells.timelines
import aspose.cells.utility
import aspose.cells.vba
import aspose.cells.webextensions

class DataMashup:
    '''Represents mashup data.'''
    
    @property
    def power_query_formulas(self) -> aspose.cells.querytables.PowerQueryFormulaCollection:
        '''Gets all power query formulas.'''
        raise NotImplementedError()
    
    @property
    def power_query_formula_parameters(self) -> aspose.cells.querytables.PowerQueryFormulaParameterCollection:
        '''Gets all parameters of power query formulas.'''
        raise NotImplementedError()
    

class PowerQueryFormula:
    '''Represents the definition of power query formula.'''
    
    @property
    def formula_definition(self) -> str:
        '''Gets the definition of the power query formula.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the power query formula.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the power query formula.'''
        raise NotImplementedError()
    
    @property
    def power_query_formula_items(self) -> aspose.cells.querytables.PowerQueryFormulaItemCollection:
        '''Gets all items of power query formula.'''
        raise NotImplementedError()
    

class PowerQueryFormulaCollection:
    '''Represents all power query formulas in the mashup data.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.querytables.PowerQueryFormula]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.querytables.PowerQueryFormula], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.querytables.PowerQueryFormula, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.querytables.PowerQueryFormula, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormula) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormula, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormula, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.querytables.PowerQueryFormula) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class PowerQueryFormulaFunction(PowerQueryFormula):
    '''Represents the function of power query.'''
    
    @property
    def formula_definition(self) -> str:
        '''Gets the definition of the power query formula.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the power query formula.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the power query formula.'''
        raise NotImplementedError()
    
    @property
    def power_query_formula_items(self) -> aspose.cells.querytables.PowerQueryFormulaItemCollection:
        '''Gets all items of power query formula.'''
        raise NotImplementedError()
    
    @property
    def f(self) -> str:
        '''Gets and sets the definition of function.'''
        raise NotImplementedError()
    
    @f.setter
    def f(self, value : str) -> None:
        '''Gets and sets the definition of function.'''
        raise NotImplementedError()
    

class PowerQueryFormulaItem:
    '''Represents the item of the power query formula.'''
    
    @property
    def name(self) -> str:
        '''Gets the name of the item.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        '''Gets the value of the item.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : str) -> None:
        '''Gets the value of the item.'''
        raise NotImplementedError()
    

class PowerQueryFormulaItemCollection:
    '''Represents all item of the power query formula.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.querytables.PowerQueryFormulaItem]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.querytables.PowerQueryFormulaItem], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.querytables.PowerQueryFormulaItem, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.querytables.PowerQueryFormulaItem, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormulaItem) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormulaItem, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormulaItem, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.querytables.PowerQueryFormulaItem) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class PowerQueryFormulaParameter:
    '''Represents the parameter of power query formula.'''
    
    @property
    def name(self) -> str:
        '''Gets the name of parameter.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets the name of parameter.'''
        raise NotImplementedError()
    
    @property
    def value(self) -> str:
        '''Gets the value of parameter.'''
        raise NotImplementedError()
    
    @value.setter
    def value(self, value : str) -> None:
        '''Gets the value of parameter.'''
        raise NotImplementedError()
    
    @property
    def parameter_definition(self) -> str:
        '''Gets the definition of the parameter.'''
        raise NotImplementedError()
    

class PowerQueryFormulaParameterCollection:
    '''Represents the parameters of power query formula.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.querytables.PowerQueryFormulaParameter]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.querytables.PowerQueryFormulaParameter], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.querytables.PowerQueryFormulaParameter, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.querytables.PowerQueryFormulaParameter, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormulaParameter) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormulaParameter, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.querytables.PowerQueryFormulaParameter, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.querytables.PowerQueryFormulaParameter) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

