/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.replica;

import io.ray.api.BaseActorHandle;
import io.ray.api.Ray;
import io.ray.runtime.serializer.MessagePackSerializer;
import io.ray.serve.api.Serve;
import io.ray.serve.config.DeploymentConfig;
import io.ray.serve.deployment.DeploymentVersion;
import io.ray.serve.deployment.DeploymentWrapper;
import io.ray.serve.exception.RayServeException;
import io.ray.serve.metrics.RayServeMetrics;
import io.ray.serve.replica.RayServeReplica;
import io.ray.serve.replica.RayServeReplicaImpl;
import io.ray.serve.util.LogUtil;
import io.ray.serve.util.ReflectUtil;
import io.ray.serve.util.ServeProtoUtil;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RayServeWrappedReplica
implements RayServeReplica {
    private static final Logger LOGGER = LoggerFactory.getLogger(RayServeReplicaImpl.class);
    private DeploymentWrapper deploymentInfo;
    private RayServeReplicaImpl replica;

    public RayServeWrappedReplica(String deploymentName, String replicaTag, String deploymentDef, byte[] initArgsbytes, byte[] deploymentConfigBytes, byte[] deploymentVersionBytes, String controllerName) {
        DeploymentConfig deploymentConfig = DeploymentConfig.fromProtoBytes(deploymentConfigBytes);
        Object[] initArgs = null;
        try {
            initArgs = this.parseInitArgs(initArgsbytes);
        }
        catch (IOException e) {
            String errMsg = LogUtil.format("Failed to initialize replica {} of deployment {}", replicaTag, this.deploymentInfo.getName());
            LOGGER.error(errMsg, e);
            throw new RayServeException(errMsg, e);
        }
        DeploymentVersion version = DeploymentVersion.fromProtoBytes(deploymentVersionBytes);
        DeploymentWrapper deploymentWrapper = new DeploymentWrapper();
        deploymentWrapper.setName(deploymentName);
        deploymentWrapper.setDeploymentDef(deploymentDef);
        deploymentWrapper.setDeploymentConfig(deploymentConfig);
        deploymentWrapper.setInitArgs(initArgs);
        deploymentWrapper.setDeploymentVersion(version);
        this.init(deploymentWrapper, replicaTag, controllerName);
    }

    public RayServeWrappedReplica(DeploymentWrapper deploymentWrapper, String replicaTag, String controllerName) {
        this.init(deploymentWrapper, replicaTag, controllerName);
    }

    private void init(DeploymentWrapper deploymentWrapper, String replicaTag, String controllerName) {
        try {
            Serve.setInternalReplicaContext(deploymentWrapper.getName(), replicaTag, controllerName, null, deploymentWrapper.getConfig());
            Class<?> deploymentClass = Class.forName(deploymentWrapper.getDeploymentDef(), true, Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElse(this.getClass().getClassLoader()));
            Object callable = ReflectUtil.getConstructor(deploymentClass, deploymentWrapper.getInitArgs()).newInstance(deploymentWrapper.getInitArgs());
            Serve.getReplicaContext().setServableObject(callable);
            Preconditions.checkArgument(StringUtils.isNotBlank(controllerName), "Must provide a valid controllerName");
            Optional optional = Ray.getActor(controllerName, "serve");
            Preconditions.checkState(optional.isPresent(), "Controller does not exist");
            this.enableMetrics(deploymentWrapper.getConfig());
            this.replica = new RayServeReplicaImpl(callable, deploymentWrapper.getDeploymentConfig(), deploymentWrapper.getDeploymentVersion(), (BaseActorHandle)optional.get());
            this.deploymentInfo = deploymentWrapper;
        }
        catch (Throwable e) {
            String errMsg = LogUtil.format("Failed to initialize replica {} of deployment {}", replicaTag, deploymentWrapper.getName());
            LOGGER.error(errMsg, e);
            throw new RayServeException(errMsg, e);
        }
    }

    private void enableMetrics(Map<String, String> config) {
        Optional.ofNullable(config).map(conf -> (String)conf.get("ray.serve.metrics.enabled")).ifPresent(enabled -> {
            if (Boolean.valueOf(enabled).booleanValue()) {
                RayServeMetrics.enable();
            } else {
                RayServeMetrics.disable();
            }
        });
    }

    private Object[] parseInitArgs(byte[] initArgsbytes) throws IOException {
        if (initArgsbytes == null || initArgsbytes.length == 0) {
            return new Object[0];
        }
        return (Object[])MessagePackSerializer.decode(initArgsbytes, Object[].class);
    }

    @Override
    public Object handleRequest(Object requestMetadata, Object requestArgs) {
        return this.replica.handleRequest(ServeProtoUtil.parseRequestMetadata((byte[])requestMetadata), requestArgs);
    }

    @Override
    public boolean checkHealth() {
        return this.replica.checkHealth();
    }

    public boolean isAllocated() {
        return true;
    }

    public Object isInitialized(byte[] deploymentConfigBytes) {
        Object deploymentVersion = this.reconfigure(deploymentConfigBytes);
        this.checkHealth();
        return deploymentVersion;
    }

    @Override
    public boolean prepareForShutdown() {
        return this.replica.prepareForShutdown();
    }

    @Override
    public Object reconfigure(byte[] deploymentConfigBytes) {
        DeploymentVersion deploymentVersion = this.replica.reconfigure(deploymentConfigBytes);
        return deploymentVersion.toProtoBytes();
    }

    public Object getVersion() {
        DeploymentVersion deploymentVersion = this.replica.getVersion();
        return deploymentVersion.toProtoBytes();
    }

    public Object getCallable() {
        return this.replica.getCallable();
    }
}

