"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonLayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * (experimental) A lambda layer version.
 *
 * @experimental
 */
class PythonLayerVersion extends lambda.LayerVersion {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_alpha_PythonLayerVersionProps(props);
        const compatibleRuntimes = (_b = props.compatibleRuntimes) !== null && _b !== void 0 ? _b : [lambda.Runtime.PYTHON_3_7];
        const compatibleArchitectures = (_c = props.compatibleArchitectures) !== null && _c !== void 0 ? _c : [lambda.Architecture.X86_64];
        // Ensure that all compatible runtimes are python
        for (const runtime of compatibleRuntimes) {
            if (runtime && runtime.family !== lambda.RuntimeFamily.PYTHON) {
                throw new Error('Only `PYTHON` runtimes are supported.');
            }
        }
        // Entry and defaults
        const entry = path.resolve(props.entry);
        // Pick the first compatibleRuntime and compatibleArchitectures to use for bundling
        const runtime = compatibleRuntimes[0];
        const architecture = compatibleArchitectures[0];
        super(scope, id, {
            ...props,
            compatibleRuntimes,
            code: bundling_1.bundle({
                entry,
                runtime,
                architecture,
                outputPathSuffix: 'python',
            }),
        });
    }
}
exports.PythonLayerVersion = PythonLayerVersion;
_a = JSII_RTTI_SYMBOL_1;
PythonLayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda-python-alpha.PythonLayerVersion", version: "2.0.0-alpha.10" };
//# sourceMappingURL=data:application/json;base64,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