def market_cap(shares_outstanding: float, price: float) -> float:
    """
    Calculate the market capitalization of a company.
    
    Market capitalization is the total market value of a company's equity,
    calculated as shares outstanding multiplied by the current share price.
    
    Args:
        shares_outstanding: Total number of shares outstanding
        price: Current share price
        
    Returns:
        Market capitalization
        
    Example:
        >>> market_cap(1000000.0, 50.0)
        50000000.0
    """
    return shares_outstanding * price

def ownership_fraction(shares_owned: float, shares_outstanding: float) -> float:
    """
    Calculate the ownership fraction for a given number of shares.
    
    This function determines what percentage of a company is owned
    based on the number of shares held relative to total shares outstanding.
    
    Args:
        shares_owned: Number of shares owned
        shares_outstanding: Total number of shares outstanding (must be positive)
        
    Returns:
        Ownership fraction as a decimal (e.g., 0.1 for 10% ownership)
        
    Raises:
        ValueError: If shares_outstanding is not positive
        
    Example:
        >>> ownership_fraction(100.0, 1000.0)
        0.1
    """
    if shares_outstanding <= 0:
        raise ValueError("shares_outstanding must be positive")
    return shares_owned / shares_outstanding