import math

def profit_call(ST: float, K: float, premium: float, r: float, tau: float) -> float:
    """
    Calculate profit/loss from holding a call option to expiration.
    
    This function calculates the net profit by subtracting the future value
    of the premium paid from the option payoff at expiration.
    
    Args:
        ST: Stock price at expiration
        K: Strike price
        premium: Option premium paid initially
        r: Risk-free rate (as decimal, e.g., 0.05 for 5%)
        tau: Time to expiration in years
        
    Returns:
        Net profit/loss (negative means loss)
        
    Example:
        >>> profit_call(110.0, 100.0, 3.0, 0.05, 1.0)
        6.846...
        >>> profit_call(90.0, 100.0, 3.0, 0.05, 1.0)
        -3.154...
    """
    payoff = max(ST - K, 0.0)
    cost = premium * math.exp(r * tau)
    return payoff - cost
