from __future__ import absolute_import, division, print_function

import sys

class VoipException(Exception):
    def __init__(self, err_code=""):
        self.err_code = err_code

    def __str__(self):
        err_code_map = {
            'account_with_dids': 'The Account has DIDs assigned to it.',
            'api_not_enabled': 'API has not been enabled or has been disabled',
            'api_limit_exceeded': 'API requests limit per minute has been reached',
            'cancel_failed': "The cancellation wasn't completed.", 'can_have_only_one_profile_without_pin': 'The conference can just have one profile member without pin',
            'conference_member_relation_not_found': 'There is no relation between the profile member and the conference.',
            'did_in_use': 'DID Number is already in use',
            'duplicated_pin': 'The given pin has been duplicated',
            'error_deleting_msg': 'Error when deleting message',
            'error_moving_msg': 'Error when move the voicemail message to folder',
            'existing_did': "You can't set a callback to an existing VoIP.ms DID number", 'exceeds_file_size': 'The file exceeds the limite size allowed.',
            'forwards_exceeded': 'Your account is limited to 4 forward entries',
            'invalid_account': 'This is not a valid account',
            'invalid_address': 'Address is missing or the format is invalid.',
            'invalid_admin': 'This is not a valid admin',
            'invalid_agent_ring_timeout': 'This is not a valid Agent ring time out value',
            'invalid_allowedcodecs': 'One of the codecs provided is invalidFormat and Values: ulaw;g729;gsm;all',
            'invalid_attachid': "The given ID is invalid or doesn't exist.", 'invalid_announce_join_leave': 'This is not a valid "Announce join leave"',
            'invalid_announce_only_user': 'This is not a valid "Announce only user"',
            'invalid_announce_position_frequency': 'This is not a valid Announce position frequency',
            'invalid_announce_round_seconds': 'This is not a valid "Announce round seconds"',
            'invalid_announce_user_count': 'This is not a valid "Announce user count"',
            'invalid_attachmessage': 'this is not a valid AttachMessageShould be: yes/no',
            'invalid_area_code': 'this is not a valid Area Code.',
            'invalid_authtype': 'This is not a valid Auth Type',
            'invalid_authtype_h323': 'You must select IP Auth to use H.323',
            'invalid_authtype_iax2': 'You must use User/Password Authentication for IAX2',
            'invalid_balancemanagement': 'This is not a valid BalanceManagement',
            'invalid_base_recording': 'This is not a valid recording path',
            'invalid_billingtype': 'This is not a valid Billing Type Allowed values: 1 = PerMinute, 2 = Flat',
            'invalid_callback': 'This is not a valid Callback',
            'invalid_callback_enable': 'This is not a valid Callback enable value',
            'invalid_callback_retry': 'This is not a valid Callback retry',
            'invalid_callerid': 'This is not a valid CallerID',
            'invalid_calleridprefix': 'This is not a valid CID Prefix, lenght should be less than 20 chars',
            'invalid_callerid_override': 'This is not a valid CallerID Override',
            'invalid_callhunting': 'This is not a valid Call Hunting',
            'invalid_canada_routing': 'This is not a valid Canada Route',
            'invalid_carrier': 'This is not a valid Carrier',
            'invalid_charge': 'This is not a valid Charge',
            'invalid_client': 'This is not a valid Client',
            'invalid_cnam': 'This is not a valid CNAMShould be: 1/0',
            'invalid_codec': 'This is not a valid Codec',
            'invalid_contact': 'This is not a valid Contact Number',
            'invalid_conference': 'This is not a valid Conference ID',
            'invalid_countryid': 'This is not a valid Country ID',
            'invalid_city': 'City is missing or the format is invalid.',
            'invalid_country': 'Country is missing or the format is invalid, must be in format ISO 3166-1 alpha-2, example: US, CA, etc. (You can use the values returned by the method getCountries)',
            'invalid_credentials': 'Username or Password is incorrect',
            'invalid_date': 'This is not a valid dateFormat is: yyyy-mm-dd',
            'invalid_datetime': 'This is not a valid datetimeFormat is: yyyy-mm-dd hh:mm:ss',
            'invalid_daterange': 'Date Range should be 92 days or less',
            'invalid_dayrange': 'This is not a valid Day Range',
            'invalid_delay_before': 'This is not a valid DelayBefore',
            'invalid_deletemessage': 'This is not a valid DeleteMessageShould be: yes/no',
            'invalid_description': 'This is not a valid Description',
            'invalid_devicetype': 'This is not a valid Device Type',
            'invalid_dialtime': 'This is not a valid Dialtime',
            'invalid_did': 'This is not a valid DID',
            'invalid_digits': 'These are not valid Digits    OrderDIDVirtual: Digits must be 3 numbers  ',
            'invalid_digit_timeout': 'This is not a valid DigitTimeOut',
            'invalid_disa': 'This is not a valid DISA',
            'invalid_destination_folder': 'This is not a valid Destination Folder',
            'invalid_drop_silence': 'This is not a valid "drop silence" value',
            'invalid_dst': 'This is not a valid Destination Number',
            'invalid_dtmf_digits': 'This is no a valid DTMF digit',
            'invalid_dtmfmode': 'This is no a valid DTMF Mode',
            'invalid_email': 'This is not a valid email or email is already in database',
            'invalid_email_attachment_format': 'This is not a valid format value',
            'invalid_email_enable': 'This is not a valid email enable value',
            'invalid_endhour': 'This is not a valid End Hour',
            'invalid_endminute': 'This is not a valid End Minute',
            'invalid_extension': 'This is not a valid extensionExtension can only contain digits',
            'invalid_failover_header': 'This is not a valid failover headerShould be: account/vm/fwd/none',
            'invalid_fax_id': 'This is not a valid Fax Message ID',
            'invalid_file': 'This is not a valid File',
            'invalid_filter': 'This is not a valid Filter',
            'invalid_folder': 'This is not a valid Folder',
            'invalid_folder_id': 'This is not a valid Fax Folder ID',
            'invalid_forward_enable': 'This is not a valid forward enable value',
            'invalid_forwarding': 'This is not a valid forwarding',
            'invalid_forwarding_did': 'Forwarding to the same did is not allowed',
            'invalid_frequency_announcement': 'This is not a valid Frequency announce',
            'invalid_from_number': 'This is not a valid sender number.',
            'invalid_attach_file': 'Valid formats: PDF, MS Word, BMP, JPG',
            'invalid_firstname': 'First name is missing or the format is invalid.',
            'invalid_foc_startdate': 'Invalid date format, must be: YYYY-mm-dd. Example: 2018-02-22',
            'invalid_foc_enddate': 'Invalid date format, must be: YYYY-mm-dd. Example: 2018-02-22',
            'invalid_id': 'This is not a valid ID',
            'invalid_if_announce_position_enabled_report_estimated_hold_time': 'This is not a Report estimated hold time type',
            'invalid_internaldialtime': 'This is not a valid Internal DialtimeShould be: 1 to 60',
            'invalid_internalvoicemail': 'This is not a valid Internal Voicemail',
            'invalid_internationalroute': 'This is not a valid International Route',
            'invalid_ip': 'This is an invalid IP',
            'invalid_ip_auth': 'Do not provide an IP address for User/Pass Authentication',
            'invalid_ip_iax2': 'Do not provide an IP address for IAX2',
            'invalid_ivr': 'This is not a valid IVR',
            'invalid_jitter_buffer': 'This is not a valid "jitter buffer" value',
            'invalid_join_empty_type': "This is not a valid 'JoinWhenEmpty' Type for a Queue", 'invalid_join_announcement': "This is not a valid 'Join Announcement' Type for a Queue", 'invalid_language': 'This is not a valid LanguageShould be: es/en/fr',
            'invalid_lastname': 'Lastname is missing or the format is invalid.',
            'invalid_listened': 'This is not a valid Listened value',
            'invalid_location': 'This is not a valid Location',
            'invalid_lockinternational': 'This is not a valid Lock International',
            'invalid_mailbox': 'This is not a valid mailbox',
            'invalid_maximum_callers': 'This is not a valid maximum callers value',
            'invalid_maximum_wait_time': 'This is not a valid maximum wait time value',
            'invalid_method': 'This is not a valid Method',
            'invalid_member': 'This is not a valid Member',
            'invalid_member_delay': 'This is not a valid Member Delay',
            'invalid_message_num': 'This is not a valid Voicemail Message Number',
            'invalid_minute': 'This is not a valid Minute Rate',
            'invalid_mixed_numbers': 'Toll-free numbers and local numbers can not be mixed in the same order.',
            'invalid_monthly': 'This is not a valid Montly Fee',
            'invalid_musiconhold': 'This is not a valid Music on Hold',
            'invalid_name': 'This is not a valid name, Alphanumeric Only',
            'invalid_nat': 'This is not a valid NAT',
            'invalid_note': 'This is not a valid Note, lenght should be less than 50 chars',
            'invalid_number': 'This is not a valid Number',
            'invalid_number_porttype': 'You have entered a local number (not valid in this portability process)',
            'invalid_number_canadian': 'You have entered a Canadian number (not valid in this portability process).',
            'invalid_number_us': 'You have entered a USA number (not valid in this portability process).',
            'invalid_number_fax': 'The Fax number can not be ported into our network',
            'invalid_number_exist': 'The number is already in our network',
            'invalid_numbermembers': 'The element format of multiple data is not correct or it size does not match with other elements',
            'invalid_order': 'This is not a valid "order" value',
            'invalid_package': 'This is not a valid Package',
            'invalid_password': 'This is not a valid passwordVoicemail: Must be 4 DigitsSubAccounts: More than 6 chars, Must Contain Alphanumeric and !#$%&/()=?*[]_:.,{}+-',
            'invalid_password_auth': 'Do not provide a Password for IP Authentication',
            'invalid_password_lessthan_8characters_long': 'This is not a valid password (Less than 8 characters long)',
            'invalid_password_missing_uppercase': 'This is not a valid password (Missing upper case character)',
            'invalid_password_missing_lowercase': 'This is not a valid password (Missing lower case character)',
            'invalid_password_ilegal_characters': 'This is not a valid password (Allowed characters: Alphanumeric and ! # $ % & / ( ) = ? * [ ] _ : . , { } + -)',
            'invalid_password_missing_number': 'This is not a valid password (Missing a number)',
            'invalid_pause': 'This is not a valid Pause',
            'invalid_payment': 'This is not a valid Payment',
            'invalid_phonebook': 'This is not a valid Phonebook',
            'invalid_phonenumber': 'This is not a valid Phone Number',
            'invalid_pin': 'This is not a valid PIN',
            'invalid_pin_number': 'Must provide the account PIN number.',
            'invalid_playinstructions': 'This is not a valid PlayInstructionsShould be: u/su',
            'invalid_priority': 'This is not a valid Priority',
            'invalid_protocol': 'This is not a valid Protocol',
            'invalid_province': 'This is not a valid Province',
            'invalid_provider_name': 'You must provide the service provider name',
            'invalid_provider_account': 'You must provide your account # with the current provider',
            'invalid_portingid': "The given ID is invalid or doesn't exist.", 'invalid_porttype': 'Must provide a valid port type.',
            'invalid_port_status': 'The status code is invalid. (You can use the values returned by the method getListStatus)',
            'invalid_quantity': 'This is not a valid quantity',
            'invalid_query': 'This is not a valid Query',
            'invalid_queue': 'This is not a valid Queue',
            'invalid_quiet': 'This is not a valid "quiet" value',
            'invalid_recording': 'This is not a valid recording',
            'invalid_recording_sound_join': '"join" is not a valid recording',
            'invalid_recording_sound_leave': '"leave" is not a valid recording',
            'invalid_recording_sound_has_joined': '"has_joined" is not a valid recording',
            'invalid_recording_sound_has_left': '"has_left" is not a valid recording',
            'invalid_recording_sound_kicked': '"kicked" is not a valid recording',
            'invalid_recording_sound_muted': '"muted" is not a valid recording',
            'invalid_recording_sound_unmuted': '"unmuted" is not a valid recording',
            'invalid_recording_sound_only_person': '"only person" is not a valid recording',
            'invalid_recording_sound_only_one': '"only one" is not a valid recording',
            'invalid_recording_sound_there_are': '"there are" is not a valid recording',
            'invalid_recording_sound_participants_muted': '"participants muted" is not a valid recording',
            'invalid_recording_sound_other_in_party': '"other in party" is not a valid recording',
            'invalid_recording_sound_place_into_conference': '"place into conference" is not a valid recording',
            'invalid_recording_sound_get_pin': '"get pin" is not a valid recording',
            'invalid_recording_sound_invalid_pin': '"invalid pin" is not a valid recording',
            'invalid_recording_sound_locked': '"locked" is not a valid recording',
            'invalid_recording_sound_locked_now': '"locked now" is not a valid recording',
            'invalid_recording_sound_unlocked_now': '"unlocked now" is not a valid recording',
            'invalid_recording_sound_error_menu': '"error menu" is not a valid recording',
            'invalid_recording_sound_participants_unmuted': '"participants unmuted" is not a valid recording',
            'invalid_report_hold_time_agent': 'This is not a valid Report hold time agent',
            'invalid_resellerclient': 'This is not a valid Reseller Client',
            'invalid_resellernextbilling': 'This is not a valid Reseller Next Billing date, date should not be set in the past.',
            'invalid_resellerpackage': 'This is not a valid Reseller Package',
            'invalid_response_timeout': 'This is not a valid ResponseTimeOut',
            'invalid_retry_timer': 'This is not a valid Retry timer',
            'invalid_ringgroup': 'This is not a valid Ring group',
            'invalid_ring_inuse': 'This is not a valid Ring in use value',
            'invalid_route': 'This is not a valid Route',
            'invalid_routing_header': 'This is not a valid Routing headerShould be: account/vm/fwd',
            'invalid_saycallerid': 'This is not a valid SayCallerIDShould be: yes/no',
            'invalid_saytime': 'This is not a valid SayTimeShould be: yes/no',
            'invalid_security_code': 'This is not a valid Security Code.Should be alphanumeric.',
            'invalid_serverpop': 'This is not a valid Server POP',
            'invalid_setup': 'This is not a valid Setup Fee',
            'invalid_silence_threshold': 'This is not a valid "silence threshold" value',
            'invalid_sipuri': 'This is not a valid SIPURI',
            'invalid_sms': 'This is not a valid SMS',
            'invalid_sms_forward': 'This is not a valid SMS forward',
            'invalid_snn': 'Must provide the 4 last digits of the SSN.',
            'invalid_statement_name': 'Statement Name is missing or the format is invalid.',
            'invalid_skippassword': 'This is not a valid skippasswordShould be: 1/0  - or -  yes/no',
            'invalid_speed_dial': 'This is not a valid Speed Dial',
            'invalid_starthour': 'This is not a valid Start Hour',
            'invalid_startminute': 'This is not a valid Start Minute',
            'invalid_start_muted': 'This is not a valid Start Muted',
            'invalid_state': 'This is not a valid State',
            'invalid_strategy': 'This is not a valid Ring Strategy',
            'invalid_talking_threshold': 'This is not a valid "talking threshold" value',
            'invalid_talk_detection': 'This is not a valid talk detection value',
            'invalid_tfnumber_porttype': 'You have entered a toll-free number (not valid in this portability process).',
            'invalid_thankyou_for_your_patience': 'This is not a valid Thankyou for your patience value',
            'Invalid_threshold': 'This is not a valid Threshold Amount. The Threshold Amount should be between 1 and 250',
            'invalid_timecondition': 'This is not a valid Time Condition',
            'invalid_timeout': 'This is not a valid timeout',
            'invalid_timerange': 'This is not a valid Timer Range',
            'invalid_timezone': 'This is not a valid TimezoneCDR and resellerCDR: Must be numericVoicemail: Values from getTimezone',
            'invalid_type': 'This is not a valid Type',
            'invalid_to_number': 'This is not a valid destination number',
            'invalid_username': 'This is not a valid Username',
            'invalid_voice_announcement': 'This is not a valid Voice announce',
            'invalid_voicemailsetup': 'This is not a valid voicemail',
            'invalid_wrapup_time': 'This is not a valid Wrapup time',
            'invalid_weekdayend': 'This is not a valid Week End',
            'invalid_weekdaystart': 'This is not a valid Week Start',
            'invalid_priority_weight': 'This is not valid weight/priority value',
            'invalid_urgent': 'This is not valid urgent value',
            'invalid_zip': 'Zip Code is missing or the format is invalid.',
            'ip_not_enabled': 'This IP is not enabled for API use',
            'limit_reached': 'You have reached the maximum number of messages allowed per day.- SMS limit using the API.- Fax limit applies using any method.',
            'max_phonebook': 'Your account is limited to 8 SIP, IAX or SIP URI members',
            'member_already_included': 'The member has been included already',
            'members_exceeded': 'You have reached the maximum allowed entries for the Phonebook',
            'message_empty': 'The SMS Message is empty',
            'message_not_found': 'The voicemail message was not found',
            'method_maintenance': 'This API method is under maintenance',
            'mismatch_email_confirm': 'e-mail confirm does not match with e-mail',
            'mismatch_password_confirm': 'Pasword confirm does not match with Password',
            'missing_account': 'Account was not provided',
            'missing_address': 'Address was not provided',
            'missing_agent_ring_timeout': 'Agent ring time out was not provided',
            'missing_allowedcodecs': 'Allowed Codecs were not provided',
            'missing_attachmessage': 'AttachMessage was not provided',
            'missing_authtype': 'Auth Type was not provided',
            'missing_balancemanagement': 'BalanceManagemente was not provided',
            'missing_billingtype': 'Billing Type was not provided',
            'missing_callback': 'Callback was not provided',
            'missing_callerid': 'CallerID was not provided',
            'missing_callhunting': 'Call hunting was not provided',
            'missing_carrier': 'Carrier was not provided',
            'missing_charge': 'Charge was not provided.',
            'missing_choices': 'Choices was not provided',
            'missing_city': 'City was not provided',
            'missing_client': 'Client was not provided',
            'missing_cnam': 'CNAM was not provided',
            'missing_codec': 'Codec was not provided',
            'missing_conference': 'Conference was not provided',
            'missing_country': 'Country was not provided',
            'missing_countryid': 'Country ID was not provided',
            'missing_credentials': 'Username or Password was not provided',
            'missing_datetime': 'DateTime value was not provided',
            'missing_delay_before': 'DelayBefore was not provided',
            'missing_deletemessage': 'DeleteMessage was not provided',
            'missing_description': 'Description was not provided',
            'missing_devicetype': 'Device Type was not provided',
            'missing_dialtime': 'Dialtime was not provided',
            'missing_did': 'DID was not provided',
            'missing_digits': 'Digits were not provided',
            'missing_digit_timeout': 'DigitTimeOut was not provided',
            'missing_disa': 'DISA was not provided',
            'missing_dtmfmode': 'DTMF Mode was not provided',
            'missing_email': 'e-mail was not provided',
            'missing_email_confirm': 'e-mail confirm was not provided',
            'missing_enable': 'Enable was not provided',
            'missing_endhour': 'End Hour was not provided',
            'missing_endminute': 'End Minute was not provided',
            'missing_failover_busy': 'Failover Busy was not provided',
            'missing_failover_noanswer': 'Failover NoAnswer was not provided',
            'missing_failover_unreachable': 'Failover Unreachable was not provided',
            'missing_file': 'File was not provided',
            'missing_filter': 'Filter was not provided',
            'missing_firstname': 'Firstname was not provided',
            'missing_folder': 'folder was not provided',
            'missing_forwarding': 'Forwarding was not provided',
            'missing_id': 'ID was not provided',
            'missing_if_announce_position_enabled_report_estimated_hold_time': "'If announce position enabled report estimated hold time' type was not provided", 'missing_internationalroute': 'International Route was not provided',
            'missing_ip': 'You need to provide an IP if you select IP Authentication Method',
            'missing_ip_h323': 'You must enter an IP Address for H.323',
            'missing_ivr': 'IVR was not provided',
            'missing_join_when_empty': "'JoinWhenEmpty' type was not provided", 'missing_language': 'Language was not provided',
            'missing_lastname': 'Lastname was not provided',
            'missing_leave_when_empty': "'LeaveWhenEmpty' type was not provided", 'missing_listened': 'Listened code was not provided',
            'missing_location': 'Location was not provided',
            'missing_lockinternational': 'Lock International was not provided',
            'missing_mailbox': 'Mailbox was not provided',
            'missing_members': 'You need at least 1 member to create a ring group',
            'missing_member': 'Member was not provided',
            'missing_message_num': 'Voicemail message number was not provided',
            'missing_method': 'Method must be provided when using the REST/JSON API',
            'missing_minute': 'Minute Rate was not provided',
            'missing_monthly': 'Monthly Fee was not provided',
            'missing_musiconhold': 'Music on Hold was not provided',
            'missing_name': 'Name was not provided',
            'missing_nat': 'NAT was not provided',
            'missing_number': 'Number was not provided',
            'missing_numbers': 'You must enter at least one valid phone number.',
            'missing_params': 'Required parameters were not provided',
            'missing_package': 'Package was not provided',
            'missing_password': 'Password was not provided',
            'missing_password_confirm': 'Password Confirm was not provided',
            'missing_payment': 'Payment was not provided.',
            'missing_phonebook': 'Phonebook was not provided',
            'missing_phonenumber': 'Phone Number was not provided',
            'missing_pin': 'PIN was not provided',
            'missing_playinstructions': 'PlayInstructions was not provided',
            'missing_priority': 'Priority was not provided',
            'missing_protocol': 'Protocol was not provided',
            'missing_province': 'Province was not provided',
            'missing_query': 'Query was not provided',
            'missing_recording': 'Recording was not provided',
            'missing_report_hold_time_agent': 'Report hold time agent was not provided',
            'missing_resellerclient': "Provide a Reseller Client or don't provide a Reseller Package", 'missing_resellerpackage': "Provide a Reseller Package or don't provide a Reseller Client", 'missing_response_timeout': 'ResponseTimeOut was not provided',
            'missing_ringgroup': 'Ring group was not provided',
            'missing_ring_inuse': 'Ring in use was not provided',
            'missing_ring_strategy': 'Ring strategy was not provided',
            'missing_route': 'Route was not provided',
            'missing_routing': 'Routing was not provided',
            'missing_saycallerid': 'SayCallerID was not provided',
            'missing_saytime': 'SayTime was not provided',
            'missing_serverpop': 'Server POP was not provided',
            'missing_setup': 'Setup Fee was not provided',
            'missing_sipuri': 'SIPURI was not provided',
            'missing_sms': 'SMS was not provided',
            'missing_skippassword': 'SkipPassword was not provided',
            'missing_speed_dial': 'Speed Dial was not provided',
            'missing_starthour': 'Start Hour was not provided',
            'missing_startminute': 'Start Minute was not provided',
            'missing_state': 'State was not provided',
            'missing_thankyou_for_your_patience': 'Thankyou for your patience was not provided',
            'missing_timecondition': 'Time Condition was not provided',
            'missing_timeout': 'Timeout was not provided',
            'missing_timezone': 'Timezone was not provided',
            'missing_type': 'Type was not provided',
            'missing_urgent': 'Urgent code was not provided',
            'missing_uri': 'URI was not provided',
            'missing_username': 'Username was not provided',
            'missing_voicemailsetup': 'Voice mail setup was not provided',
            'missing_weekdayend': 'Week End was not provide',
            'missing_weekdaystart': ' Week Start was not provided',
            'missing_priority_weight': ' Priority/Weight was not provided',
            'missing_zip': 'Zip Code was not provided',
            'moving_fail': 'The Fax Message was not moved',
            'name_toolong': 'The name exceeds character size limit',
            'non_sufficient_funds': 'Your account does not have sufficient funds to proceed',
            'no_account': 'There are no accounts',
            'no_attachments': 'Theres no attachments records to show.',
            'no_base64file': 'File not encoded in base64',
            'no_callback': 'There are not Callbacks',
            'no_callhunting': 'There are no Call Huntings',
            'no_callstatus': 'No Call Status was provided.One of the following parameters needs to be set to "1": answered, noanswer, busy, failed',
            'no_cdr': 'There are no CDR entries for the filter',
            'no_change_billingtype': 'Imposible change DID billing plan',
            'no_client': 'There are no Clients',
            'no_conference': 'There are no Conferences',
            'no_did': 'There are no DIDs',
            'no_disa': 'There are no DISAs',
            'no_filter': 'There are no Filters',
            'no_forwarding': 'There was no Forwarding',
            'no_ivr': 'There are no ivr',
            'no_mailbox': 'There are no Mailboxes',
            'no_message': 'There are no Fax Message(s)',
            'no_messages': 'There are no Voicemail Message(s)',
            'no_member': 'There are no Static Members',
            'no_numbers': 'There are no Fax Numbers',
            'no_package': 'there are no Packages',
            'no_phonebook': 'There are no Phonebook entries',
            'no_queue': 'There are no Queue entries',
            'no_rate': 'There are no Rates',
            'no_recording': 'There are no recordings',
            'no_ringgroup': 'There are no Ring groups',
            'no_sipuri': 'There are no SIP URIs',
            'no_sms': 'There are no SMS messages',
            'no_timecondition': 'There are no Time Conditions',
            'note_toolong': 'The note exceeds character size limit',
            'order_failed': "The order wasn't completed.", 'provider_outofservice': 'One of our providers is out of service',
            'recording_in_use_did': 'You have a DID using this Recording',
            'recording_in_use_queue': 'You have a Calling Queue using this Recording',
            'recording_in_use_ivr': 'You have an IVR using this Recording',
            'recording_in_use_caller_id_filtering': 'You have a Caller ID Filtering using this Recording',
            'recording_in_use_caller_timecondition': 'You have a Time Condition using this Recording',
            'repeated_ip': 'You already have a Subaccount using this IP and Protocol',
            'reserved_ip': 'This is a reserved IP used by VoIP.ms or other Companies',
            'same_did_billingtype': 'The Billing Type provided and DID billing type are the same',
            'sipuri_in_phonebook': "This SIPURI can't be deleted, it is mapped in the phonebook", 'sent_fail': "The Fax Message it wasn't send.", 'sms_toolong': 'The SMS message exceeds 160 characters',
            'sms_failed': 'The SMS message was not sent',
            'tls_error': 'Theres was a TLS error, please try later.',
            'Unable_to_purchase': 'Unable to purchase DIDs',
            'unavailable_info': 'The information you requested is unavailable at this moment',
            'unsifficient_stock': 'Theres no sufficient stock to complete the order.',
            'used_description': 'You already have a record with this Description',
            'used_extension': 'You already have a subaccount using this extension',
            'used_filter': 'You already have a record with this Filter',
            'used_ip': 'There is already another customer using this IP Address',
            'used_name': 'You already have an entry using this name',
            'used_number': 'You already have a record with this Number',
            'used_password': 'This password has been used previously by this account.',
            'used_speed_dial': 'You have an entry with this Speed Dial',
            'used_username': 'You already have a subaccount using this Username.',
            'weak_password': 'This Password is too weak or too common'}
        err_desc = err_code_map[self.err_code] or self.err_code
        return "API Call failed as: {}".format(err_desc)

    

class VoipRestException(VoipException):
    def __str__(self):
        return self.err_code or "<empty message>"