# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSoftwareSourceSoftwarePackagesResult',
    'AwaitableGetSoftwareSourceSoftwarePackagesResult',
    'get_software_source_software_packages',
    'get_software_source_software_packages_output',
]

@pulumi.output_type
class GetSoftwareSourceSoftwarePackagesResult:
    """
    A collection of values returned by getSoftwareSourceSoftwarePackages.
    """
    def __init__(__self__, display_name=None, display_name_contains=None, filters=None, id=None, is_latest=None, software_package_collections=None, software_source_id=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if display_name_contains and not isinstance(display_name_contains, str):
            raise TypeError("Expected argument 'display_name_contains' to be a str")
        pulumi.set(__self__, "display_name_contains", display_name_contains)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if software_package_collections and not isinstance(software_package_collections, list):
            raise TypeError("Expected argument 'software_package_collections' to be a list")
        pulumi.set(__self__, "software_package_collections", software_package_collections)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Software source name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="displayNameContains")
    def display_name_contains(self) -> Optional[str]:
        return pulumi.get(self, "display_name_contains")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSoftwareSourceSoftwarePackagesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> Optional[bool]:
        """
        Indicates whether this package is the latest version.
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="softwarePackageCollections")
    def software_package_collections(self) -> Sequence['outputs.GetSoftwareSourceSoftwarePackagesSoftwarePackageCollectionResult']:
        """
        The list of software_package_collection.
        """
        return pulumi.get(self, "software_package_collections")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> str:
        return pulumi.get(self, "software_source_id")


class AwaitableGetSoftwareSourceSoftwarePackagesResult(GetSoftwareSourceSoftwarePackagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceSoftwarePackagesResult(
            display_name=self.display_name,
            display_name_contains=self.display_name_contains,
            filters=self.filters,
            id=self.id,
            is_latest=self.is_latest,
            software_package_collections=self.software_package_collections,
            software_source_id=self.software_source_id)


def get_software_source_software_packages(display_name: Optional[str] = None,
                                          display_name_contains: Optional[str] = None,
                                          filters: Optional[Sequence[pulumi.InputType['GetSoftwareSourceSoftwarePackagesFilterArgs']]] = None,
                                          is_latest: Optional[bool] = None,
                                          software_source_id: Optional[str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceSoftwarePackagesResult:
    """
    This data source provides the list of Software Source Software Packages in Oracle Cloud Infrastructure Os Management Hub service.

    Lists software packages in the specified software source.  Filter the list against a variety of criteria
    including but not limited to its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_software_packages = oci.OsManagementHub.get_software_source_software_packages(software_source_id=test_software_source["id"],
        display_name=software_source_software_package_display_name,
        display_name_contains=software_source_software_package_display_name_contains,
        is_latest=software_source_software_package_is_latest)
    ```


    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param bool is_latest: Indicates whether to list only the latest versions of packages, module streams, and stream profiles.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['displayNameContains'] = display_name_contains
    __args__['filters'] = filters
    __args__['isLatest'] = is_latest
    __args__['softwareSourceId'] = software_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSourceSoftwarePackages:getSoftwareSourceSoftwarePackages', __args__, opts=opts, typ=GetSoftwareSourceSoftwarePackagesResult).value

    return AwaitableGetSoftwareSourceSoftwarePackagesResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        display_name_contains=pulumi.get(__ret__, 'display_name_contains'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        software_package_collections=pulumi.get(__ret__, 'software_package_collections'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'))


@_utilities.lift_output_func(get_software_source_software_packages)
def get_software_source_software_packages_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                                 display_name_contains: Optional[pulumi.Input[Optional[str]]] = None,
                                                 filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSoftwareSourceSoftwarePackagesFilterArgs']]]]] = None,
                                                 is_latest: Optional[pulumi.Input[Optional[bool]]] = None,
                                                 software_source_id: Optional[pulumi.Input[str]] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSoftwareSourceSoftwarePackagesResult]:
    """
    This data source provides the list of Software Source Software Packages in Oracle Cloud Infrastructure Os Management Hub service.

    Lists software packages in the specified software source.  Filter the list against a variety of criteria
    including but not limited to its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_software_packages = oci.OsManagementHub.get_software_source_software_packages(software_source_id=test_software_source["id"],
        display_name=software_source_software_package_display_name,
        display_name_contains=software_source_software_package_display_name_contains,
        is_latest=software_source_software_package_is_latest)
    ```


    :param str display_name: A filter to return resources that match the given user-friendly name.
    :param str display_name_contains: A filter to return resources that may partially match the given display name.
    :param bool is_latest: Indicates whether to list only the latest versions of packages, module streams, and stream profiles.
    :param str software_source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the software source.
    """
    ...
