# generated by datamodel-codegen:
#   filename:  api/addGlossaryToAssetsRequest.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import entityReferenceList, tagLabel


class Operation(Enum):
    AddAssets = 'AddAssets'
    AddGlossaryTags = 'AddGlossaryTags'


class AddGlossaryToAssetsRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    operation: Annotated[
        Optional[Operation], Field(None, description='Operation to be performed')
    ]
    dryRun: Annotated[
        Optional[bool],
        Field(
            True,
            description='If true, the request will be validated but no changes will be made',
        ),
    ]
    glossaryTags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Glossary Tags to be added'),
    ]
    assets: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='List of assets to be created against which the glossary needs to be added.',
        ),
    ]
