# generated by datamodel-codegen:
#   filename:  api/tests/createTestCase.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...tests import testCase
from ...type import basic, entityReferenceList


class CreateTestCaseRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.TestCaseEntityName,
        Field(description='Name that identifies this test case.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the testcase.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this test.'),
    ]
    testDefinition: Annotated[
        basic.FullyQualifiedEntityName,
        Field(description='Fully qualified name of the test definition.'),
    ]
    entityLink: basic.EntityLink
    testSuite: Annotated[
        basic.FullyQualifiedEntityName,
        Field(description='Fully qualified name of the testSuite'),
    ]
    parameterValues: Optional[List[testCase.TestCaseParameterValue]] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this test'),
    ]
    computePassedFailedRowCount: Annotated[
        Optional[bool],
        Field(
            False,
            description='Compute the passed and failed row count for the test case.',
        ),
    ]
    useDynamicAssertion: Annotated[
        Optional[bool],
        Field(
            False,
            description='If the test definition supports it, use dynamic assertion to evaluate the test case.',
        ),
    ]
