# generated by datamodel-codegen:
#   filename:  dataInsight/kpi/kpi.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList
from . import basic as basic_1


class Kpi(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this KPI Definition instance.'),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this KPI Definition.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this KPI Definition.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName same as `name`.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the KpiObjective.')
    ]
    metricType: basic_1.KpiTargetType
    dataInsightChart: Annotated[
        entityReference.EntityReference,
        Field(description='Data Insight Chart Referred by this Kpi Objective.'),
    ]
    targetValue: Annotated[
        float,
        Field(
            description='Metrics from the chart and the target to achieve the result.'
        ),
    ]
    kpiResult: Annotated[
        Optional[basic_1.KpiResult], Field(None, description='Result of the Kpi')
    ]
    startDate: Annotated[basic.Timestamp, Field(description='Start Date for the KPIs')]
    endDate: Annotated[basic.Timestamp, Field(description='End Date for the KPIs')]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this KPI definition.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domain: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Domain the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
