# generated by datamodel-codegen:
#   filename:  entity/services/connections/api/restConnection.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr


class RestType(Enum):
    Rest = 'Rest'


class RestConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[RestType],
        Field(RestType.Rest, description='REST API Type', title='REST API Type'),
    ]
    openAPISchemaURL: Annotated[
        AnyUrl, Field(description='Open API Schema URL.', title='OpenAPISchemaURL')
    ]
    token: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Generated Token to connect to OpenAPI Schema.',
            title='Token',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[bool],
        Field(
            True,
            description='Supports Metadata Extraction.',
            title='Supports Metadata Extraction',
        ),
    ]
