# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/lightdashConnection.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class LightdashType(Enum):
    Lightdash = 'Lightdash'


class LightdashConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[LightdashType],
        Field(
            LightdashType.Lightdash, description='Service Type', title='Service Type'
        ),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Address for your running Lightdash instance', title='Host Port'
        ),
    ]
    apiKey: Annotated[
        CustomSecretStr,
        Field(
            description='The personal access token you can generate in the Lightdash app under the user settings',
            title='API Key',
        ),
    ]
    projectUUID: Annotated[
        str,
        Field(
            description='The Project UUID for your Lightdash instance',
            title='Project UUID',
        ),
    ]
    spaceUUID: Annotated[
        str,
        Field(
            description='The Space UUID for your Lightdash instance', title='Space UUID'
        ),
    ]
    proxyAuthentication: Annotated[
        Optional[CustomSecretStr],
        Field(
            None,
            description='Use if your Lightdash instance is behind a proxy like (Cloud IAP)',
            title='Proxy Authentication',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
