# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/amundsenConnection.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class AmundsenType(Enum):
    Amundsen = 'Amundsen'


class AmundsenConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AmundsenType], Field(AmundsenType.Amundsen, description='Service Type')
    ]
    username: Annotated[
        str, Field(description='username to connect to the Amundsen Neo4j Connection.')
    ]
    password: Annotated[
        CustomSecretStr,
        Field(description='password to connect to the Amundsen Neo4j Connection.'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Host and port of the Amundsen Neo4j Connection. This expect a URI format like: bolt://localhost:7687.',
            title='Host and Port',
        ),
    ]
    maxConnectionLifeTime: Annotated[
        Optional[int],
        Field(
            50,
            description='Maximum connection lifetime for the Amundsen Neo4j Connection.',
        ),
    ]
    validateSSL: Annotated[
        Optional[bool],
        Field(
            False,
            description='Enable SSL validation for the Amundsen Neo4j Connection.',
        ),
    ]
    encrypted: Annotated[
        Optional[bool],
        Field(
            False, description='Enable encryption for the Amundsen Neo4j Connection.'
        ),
    ]
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
