# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/dagsterConnection.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class DagsterType(Enum):
    Dagster = 'Dagster'


class DagsterConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[DagsterType],
        Field(DagsterType.Dagster, description='Service Type', title='Service Type'),
    ]
    host: Annotated[
        AnyUrl, Field(description='URL to the Dagster instance', title='Host')
    ]
    token: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='To Connect to Dagster Cloud', title='Token'),
    ]
    timeout: Annotated[
        Optional[int],
        Field(
            '1000',
            description='Connection Time Limit Between OM and Dagster Graphql API in second',
            title='Time Out',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
