# generated by datamodel-codegen:
#   filename:  governance/workflows/elements/triggers/eventBasedEntityTrigger.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class Event(Enum):
    Created = 'Created'
    Updated = 'Updated'


class Config(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    entityType: Annotated[
        str, Field(description='Entity Type for which it should be triggered.')
    ]
    events: List[Event]
    exclude: Annotated[
        Optional[List[str]],
        Field(None, description='Exclude events that only modify given attributes.'),
    ]


class EventBasedEntityTriggerDefinition(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Optional[str] = 'eventBasedEntityTrigger'
    config: Optional[Config] = None
    output: Annotated[
        Optional[List[str]], Field(['relatedEntity'], max_length=1, min_length=1)
    ]
