# generated by datamodel-codegen:
#   filename:  governance/workflows/workflowInstanceState.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from typing import Any, Dict, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic


class Stage(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[basic.EntityName] = None
    startedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None, description='Timestamp on which the workflow instance stage started.'
        ),
    ]
    endedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None, description='Timestamp on which the workflow instance stage ended.'
        ),
    ]
    tasks: Optional[List[basic.Uuid]] = []
    variables: Optional[Dict[str, Any]] = None


class WorkflowInstanceState(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this workflow instance state.'),
    ]
    workflowInstanceId: Annotated[
        Optional[basic.Uuid], Field(None, description='Workflow Instance ID.')
    ]
    workflowInstanceExecutionId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='One WorkflowInstance might execute a flow multiple times. This ID groups together the States of one of those flows.',
        ),
    ]
    workflowDefinitionId: Annotated[
        Optional[basic.Uuid], Field(None, description='Workflow Definition Reference.')
    ]
    stage: Optional[Stage] = None
    timestamp: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Timestamp on which the workflow instance state was created.',
        ),
    ]
    exception: Annotated[
        Optional[bool],
        Field(
            None,
            description="If the Workflow Instance has errors, 'True'. Else, 'False'.",
        ),
    ]
