# generated by datamodel-codegen:
#   filename:  type/entityHierarchy.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class EntityHierarchy(BaseModel):
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier of an entity hierarchy instance.'),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Preferred name for the entity hierarchy.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display name that identifies this hierarchy.'),
    ]
    description: Annotated[
        basic.Markdown, Field(description='Description of the entity hierarchy.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='A unique name that identifies an entity within the hierarchy. It captures name hierarchy in the form of `rootEntity.childEntity`.',
        ),
    ]
    children: Annotated[
        Optional[EntityHierarchyList],
        Field(None, description='Other entities that are children of this entity.'),
    ]


class EntityHierarchyList(RootModel[List[EntityHierarchy]]):
    root: List[EntityHierarchy]


EntityHierarchy.model_rebuild()
