# generated by datamodel-codegen:
#   filename:  type/entityReference.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic


class EntityReference(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies an entity instance.'),
    ]
    type: Annotated[
        str,
        Field(
            description='Entity type/class name - Examples: `database`, `table`, `metrics`, `databaseService`, `dashboardService`...'
        ),
    ]
    name: Annotated[
        Optional[str], Field(None, description='Name of the entity instance.')
    ]
    fullyQualifiedName: Annotated[
        Optional[str],
        Field(
            None,
            description="Fully qualified name of the entity instance. For entities such as tables, databases fullyQualifiedName is returned in this field. For entities that don't have name hierarchy such as `user` and `team` this will be same as the `name` field.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Optional description of entity.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            None, description='If true the entity referred to has been soft-deleted.'
        ),
    ]
    inherited: Annotated[
        Optional[bool],
        Field(
            None,
            description='If true the relationship indicated by this entity reference is inherited from the parent entity.',
        ),
    ]
    href: Annotated[
        Optional[basic.Href], Field(None, description='Link to the entity resource.')
    ]
