# generated by datamodel-codegen:
#   filename:  type/lifeCycle.json
#   timestamp: 2025-02-28T14:54:55+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import basic, entityReference


class AccessDetails(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    timestamp: Annotated[
        basic.Timestamp,
        Field(
            description='Timestamp of data asset accessed for creation, update, read.'
        ),
    ]
    accessedBy: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='User, Pipeline, Query that created,updated or accessed the data asset',
        ),
    ]
    accessedByAProcess: Annotated[
        Optional[str],
        Field(
            None,
            description='Any process that accessed the data asset that is not captured in OpenMetadata.',
        ),
    ]


class LifeCycle(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    created: Annotated[
        Optional[AccessDetails],
        Field(
            None, description='Access Details about created aspect of the data asset'
        ),
    ]
    updated: Annotated[
        Optional[AccessDetails],
        Field(
            None, description='Access Details about updated aspect of the data asset'
        ),
    ]
    accessed: Annotated[
        Optional[AccessDetails],
        Field(
            None, description='Access Details about accessed aspect of the data asset'
        ),
    ]
