# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AllowedProtocolsTacacsArgs', 'AllowedProtocolsTacacs']

@pulumi.input_type
class AllowedProtocolsTacacsArgs:
    def __init__(__self__, *,
                 allow_chap: pulumi.Input[builtins.bool],
                 allow_ms_chap_v1: pulumi.Input[builtins.bool],
                 allow_pap_ascii: pulumi.Input[builtins.bool],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AllowedProtocolsTacacs resource.
        :param pulumi.Input[builtins.bool] allow_chap: Allow CHAP
        :param pulumi.Input[builtins.bool] allow_ms_chap_v1: Allow MS CHAP v1
        :param pulumi.Input[builtins.bool] allow_pap_ascii: Allow PAP ASCII
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the allowed protocols
        """
        pulumi.set(__self__, "allow_chap", allow_chap)
        pulumi.set(__self__, "allow_ms_chap_v1", allow_ms_chap_v1)
        pulumi.set(__self__, "allow_pap_ascii", allow_pap_ascii)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="allowChap")
    def allow_chap(self) -> pulumi.Input[builtins.bool]:
        """
        Allow CHAP
        """
        return pulumi.get(self, "allow_chap")

    @allow_chap.setter
    def allow_chap(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "allow_chap", value)

    @property
    @pulumi.getter(name="allowMsChapV1")
    def allow_ms_chap_v1(self) -> pulumi.Input[builtins.bool]:
        """
        Allow MS CHAP v1
        """
        return pulumi.get(self, "allow_ms_chap_v1")

    @allow_ms_chap_v1.setter
    def allow_ms_chap_v1(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "allow_ms_chap_v1", value)

    @property
    @pulumi.getter(name="allowPapAscii")
    def allow_pap_ascii(self) -> pulumi.Input[builtins.bool]:
        """
        Allow PAP ASCII
        """
        return pulumi.get(self, "allow_pap_ascii")

    @allow_pap_ascii.setter
    def allow_pap_ascii(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "allow_pap_ascii", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the allowed protocols
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AllowedProtocolsTacacsState:
    def __init__(__self__, *,
                 allow_chap: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_ms_chap_v1: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_pap_ascii: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AllowedProtocolsTacacs resources.
        :param pulumi.Input[builtins.bool] allow_chap: Allow CHAP
        :param pulumi.Input[builtins.bool] allow_ms_chap_v1: Allow MS CHAP v1
        :param pulumi.Input[builtins.bool] allow_pap_ascii: Allow PAP ASCII
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the allowed protocols
        """
        if allow_chap is not None:
            pulumi.set(__self__, "allow_chap", allow_chap)
        if allow_ms_chap_v1 is not None:
            pulumi.set(__self__, "allow_ms_chap_v1", allow_ms_chap_v1)
        if allow_pap_ascii is not None:
            pulumi.set(__self__, "allow_pap_ascii", allow_pap_ascii)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="allowChap")
    def allow_chap(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow CHAP
        """
        return pulumi.get(self, "allow_chap")

    @allow_chap.setter
    def allow_chap(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_chap", value)

    @property
    @pulumi.getter(name="allowMsChapV1")
    def allow_ms_chap_v1(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow MS CHAP v1
        """
        return pulumi.get(self, "allow_ms_chap_v1")

    @allow_ms_chap_v1.setter
    def allow_ms_chap_v1(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_ms_chap_v1", value)

    @property
    @pulumi.getter(name="allowPapAscii")
    def allow_pap_ascii(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow PAP ASCII
        """
        return pulumi.get(self, "allow_pap_ascii")

    @allow_pap_ascii.setter
    def allow_pap_ascii(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_pap_ascii", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the allowed protocols
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


class AllowedProtocolsTacacs(pulumi.CustomResource):

    pulumi_type = "ise:deviceadmin/allowedProtocolsTacacs:AllowedProtocolsTacacs"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_chap: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_ms_chap_v1: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_pap_ascii: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a TACACS allowed protocols policy element.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.AllowedProtocolsTacacs("example",
            name="Protocols1",
            description="My allowed TACACS protocols",
            allow_pap_ascii=True,
            allow_chap=True,
            allow_ms_chap_v1=True)
        ```

        ## Import

        ```sh
        $ pulumi import ise:deviceadmin/allowedProtocolsTacacs:AllowedProtocolsTacacs example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_chap: Allow CHAP
        :param pulumi.Input[builtins.bool] allow_ms_chap_v1: Allow MS CHAP v1
        :param pulumi.Input[builtins.bool] allow_pap_ascii: Allow PAP ASCII
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the allowed protocols
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AllowedProtocolsTacacsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a TACACS allowed protocols policy element.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.deviceadmin.AllowedProtocolsTacacs("example",
            name="Protocols1",
            description="My allowed TACACS protocols",
            allow_pap_ascii=True,
            allow_chap=True,
            allow_ms_chap_v1=True)
        ```

        ## Import

        ```sh
        $ pulumi import ise:deviceadmin/allowedProtocolsTacacs:AllowedProtocolsTacacs example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param AllowedProtocolsTacacsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AllowedProtocolsTacacsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_chap: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_ms_chap_v1: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_pap_ascii: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AllowedProtocolsTacacsArgs.__new__(AllowedProtocolsTacacsArgs)

            if allow_chap is None and not opts.urn:
                raise TypeError("Missing required property 'allow_chap'")
            __props__.__dict__["allow_chap"] = allow_chap
            if allow_ms_chap_v1 is None and not opts.urn:
                raise TypeError("Missing required property 'allow_ms_chap_v1'")
            __props__.__dict__["allow_ms_chap_v1"] = allow_ms_chap_v1
            if allow_pap_ascii is None and not opts.urn:
                raise TypeError("Missing required property 'allow_pap_ascii'")
            __props__.__dict__["allow_pap_ascii"] = allow_pap_ascii
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
        super(AllowedProtocolsTacacs, __self__).__init__(
            'ise:deviceadmin/allowedProtocolsTacacs:AllowedProtocolsTacacs',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_chap: Optional[pulumi.Input[builtins.bool]] = None,
            allow_ms_chap_v1: Optional[pulumi.Input[builtins.bool]] = None,
            allow_pap_ascii: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None) -> 'AllowedProtocolsTacacs':
        """
        Get an existing AllowedProtocolsTacacs resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_chap: Allow CHAP
        :param pulumi.Input[builtins.bool] allow_ms_chap_v1: Allow MS CHAP v1
        :param pulumi.Input[builtins.bool] allow_pap_ascii: Allow PAP ASCII
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] name: The name of the allowed protocols
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AllowedProtocolsTacacsState.__new__(_AllowedProtocolsTacacsState)

        __props__.__dict__["allow_chap"] = allow_chap
        __props__.__dict__["allow_ms_chap_v1"] = allow_ms_chap_v1
        __props__.__dict__["allow_pap_ascii"] = allow_pap_ascii
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        return AllowedProtocolsTacacs(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowChap")
    def allow_chap(self) -> pulumi.Output[builtins.bool]:
        """
        Allow CHAP
        """
        return pulumi.get(self, "allow_chap")

    @property
    @pulumi.getter(name="allowMsChapV1")
    def allow_ms_chap_v1(self) -> pulumi.Output[builtins.bool]:
        """
        Allow MS CHAP v1
        """
        return pulumi.get(self, "allow_ms_chap_v1")

    @property
    @pulumi.getter(name="allowPapAscii")
    def allow_pap_ascii(self) -> pulumi.Output[builtins.bool]:
        """
        Allow PAP ASCII
        """
        return pulumi.get(self, "allow_pap_ascii")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the allowed protocols
        """
        return pulumi.get(self, "name")

