# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EgressMatrixCellArgs', 'EgressMatrixCell']

@pulumi.input_type
class EgressMatrixCellArgs:
    def __init__(__self__, *,
                 destination_sgt_id: pulumi.Input[builtins.str],
                 source_sgt_id: pulumi.Input[builtins.str],
                 default_rule: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[builtins.str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a EgressMatrixCell resource.
        :param pulumi.Input[builtins.str] destination_sgt_id: Destination Trustsec Security Group ID
        :param pulumi.Input[builtins.str] source_sgt_id: Source Trustsec Security Group ID
        :param pulumi.Input[builtins.str] default_rule: Can be used only if sgacls not specified. - Choices: `NONE`, `DENY_IP`, `PERMIT_IP` - Default value: `NONE`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sgacls: List of TrustSec Security Groups ACLs
        """
        pulumi.set(__self__, "destination_sgt_id", destination_sgt_id)
        pulumi.set(__self__, "source_sgt_id", source_sgt_id)
        if default_rule is not None:
            pulumi.set(__self__, "default_rule", default_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if matrix_cell_status is not None:
            pulumi.set(__self__, "matrix_cell_status", matrix_cell_status)
        if sgacls is not None:
            pulumi.set(__self__, "sgacls", sgacls)

    @property
    @pulumi.getter(name="destinationSgtId")
    def destination_sgt_id(self) -> pulumi.Input[builtins.str]:
        """
        Destination Trustsec Security Group ID
        """
        return pulumi.get(self, "destination_sgt_id")

    @destination_sgt_id.setter
    def destination_sgt_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_sgt_id", value)

    @property
    @pulumi.getter(name="sourceSgtId")
    def source_sgt_id(self) -> pulumi.Input[builtins.str]:
        """
        Source Trustsec Security Group ID
        """
        return pulumi.get(self, "source_sgt_id")

    @source_sgt_id.setter
    def source_sgt_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_sgt_id", value)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be used only if sgacls not specified. - Choices: `NONE`, `DENY_IP`, `PERMIT_IP` - Default value: `NONE`
        """
        return pulumi.get(self, "default_rule")

    @default_rule.setter
    def default_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="matrixCellStatus")
    def matrix_cell_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        """
        return pulumi.get(self, "matrix_cell_status")

    @matrix_cell_status.setter
    def matrix_cell_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "matrix_cell_status", value)

    @property
    @pulumi.getter
    def sgacls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of TrustSec Security Groups ACLs
        """
        return pulumi.get(self, "sgacls")

    @sgacls.setter
    def sgacls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sgacls", value)


@pulumi.input_type
class _EgressMatrixCellState:
    def __init__(__self__, *,
                 default_rule: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_sgt_id: Optional[pulumi.Input[builtins.str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[builtins.str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_sgt_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EgressMatrixCell resources.
        :param pulumi.Input[builtins.str] default_rule: Can be used only if sgacls not specified. - Choices: `NONE`, `DENY_IP`, `PERMIT_IP` - Default value: `NONE`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] destination_sgt_id: Destination Trustsec Security Group ID
        :param pulumi.Input[builtins.str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sgacls: List of TrustSec Security Groups ACLs
        :param pulumi.Input[builtins.str] source_sgt_id: Source Trustsec Security Group ID
        """
        if default_rule is not None:
            pulumi.set(__self__, "default_rule", default_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_sgt_id is not None:
            pulumi.set(__self__, "destination_sgt_id", destination_sgt_id)
        if matrix_cell_status is not None:
            pulumi.set(__self__, "matrix_cell_status", matrix_cell_status)
        if sgacls is not None:
            pulumi.set(__self__, "sgacls", sgacls)
        if source_sgt_id is not None:
            pulumi.set(__self__, "source_sgt_id", source_sgt_id)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be used only if sgacls not specified. - Choices: `NONE`, `DENY_IP`, `PERMIT_IP` - Default value: `NONE`
        """
        return pulumi.get(self, "default_rule")

    @default_rule.setter
    def default_rule(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationSgtId")
    def destination_sgt_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Destination Trustsec Security Group ID
        """
        return pulumi.get(self, "destination_sgt_id")

    @destination_sgt_id.setter
    def destination_sgt_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_sgt_id", value)

    @property
    @pulumi.getter(name="matrixCellStatus")
    def matrix_cell_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        """
        return pulumi.get(self, "matrix_cell_status")

    @matrix_cell_status.setter
    def matrix_cell_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "matrix_cell_status", value)

    @property
    @pulumi.getter
    def sgacls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of TrustSec Security Groups ACLs
        """
        return pulumi.get(self, "sgacls")

    @sgacls.setter
    def sgacls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "sgacls", value)

    @property
    @pulumi.getter(name="sourceSgtId")
    def source_sgt_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Source Trustsec Security Group ID
        """
        return pulumi.get(self, "source_sgt_id")

    @source_sgt_id.setter
    def source_sgt_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_sgt_id", value)


class EgressMatrixCell(pulumi.CustomResource):

    pulumi_type = "ise:trustsec/egressMatrixCell:EgressMatrixCell"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rule: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_sgt_id: Optional[pulumi.Input[builtins.str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[builtins.str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_sgt_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a TrustSec Egress Matrix Cell.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.EgressMatrixCell("example",
            description="EgressMatrixCell Description",
            default_rule="NONE",
            matrix_cell_status="ENABLED",
            sgacls=["26b76b10-66e6-11ee-9cc1-9eb2a3ecc82a, 9d64dcd0-6384-11ee-9cc1-9eb2a3ecc82a"],
            source_sgt_id="93c66ed0-8c01-11e6-996c-525400b48521",
            destination_sgt_id="93e1bf00-8c01-11e6-996c-525400b48521")
        ```

        ## Import

        ```sh
        $ pulumi import ise:trustsec/egressMatrixCell:EgressMatrixCell example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_rule: Can be used only if sgacls not specified. - Choices: `NONE`, `DENY_IP`, `PERMIT_IP` - Default value: `NONE`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] destination_sgt_id: Destination Trustsec Security Group ID
        :param pulumi.Input[builtins.str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sgacls: List of TrustSec Security Groups ACLs
        :param pulumi.Input[builtins.str] source_sgt_id: Source Trustsec Security Group ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EgressMatrixCellArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a TrustSec Egress Matrix Cell.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.EgressMatrixCell("example",
            description="EgressMatrixCell Description",
            default_rule="NONE",
            matrix_cell_status="ENABLED",
            sgacls=["26b76b10-66e6-11ee-9cc1-9eb2a3ecc82a, 9d64dcd0-6384-11ee-9cc1-9eb2a3ecc82a"],
            source_sgt_id="93c66ed0-8c01-11e6-996c-525400b48521",
            destination_sgt_id="93e1bf00-8c01-11e6-996c-525400b48521")
        ```

        ## Import

        ```sh
        $ pulumi import ise:trustsec/egressMatrixCell:EgressMatrixCell example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param EgressMatrixCellArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EgressMatrixCellArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rule: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_sgt_id: Optional[pulumi.Input[builtins.str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[builtins.str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_sgt_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EgressMatrixCellArgs.__new__(EgressMatrixCellArgs)

            __props__.__dict__["default_rule"] = default_rule
            __props__.__dict__["description"] = description
            if destination_sgt_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_sgt_id'")
            __props__.__dict__["destination_sgt_id"] = destination_sgt_id
            __props__.__dict__["matrix_cell_status"] = matrix_cell_status
            __props__.__dict__["sgacls"] = sgacls
            if source_sgt_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_sgt_id'")
            __props__.__dict__["source_sgt_id"] = source_sgt_id
        super(EgressMatrixCell, __self__).__init__(
            'ise:trustsec/egressMatrixCell:EgressMatrixCell',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_rule: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination_sgt_id: Optional[pulumi.Input[builtins.str]] = None,
            matrix_cell_status: Optional[pulumi.Input[builtins.str]] = None,
            sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            source_sgt_id: Optional[pulumi.Input[builtins.str]] = None) -> 'EgressMatrixCell':
        """
        Get an existing EgressMatrixCell resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] default_rule: Can be used only if sgacls not specified. - Choices: `NONE`, `DENY_IP`, `PERMIT_IP` - Default value: `NONE`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] destination_sgt_id: Destination Trustsec Security Group ID
        :param pulumi.Input[builtins.str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] sgacls: List of TrustSec Security Groups ACLs
        :param pulumi.Input[builtins.str] source_sgt_id: Source Trustsec Security Group ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EgressMatrixCellState.__new__(_EgressMatrixCellState)

        __props__.__dict__["default_rule"] = default_rule
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_sgt_id"] = destination_sgt_id
        __props__.__dict__["matrix_cell_status"] = matrix_cell_status
        __props__.__dict__["sgacls"] = sgacls
        __props__.__dict__["source_sgt_id"] = source_sgt_id
        return EgressMatrixCell(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> pulumi.Output[builtins.str]:
        """
        Can be used only if sgacls not specified. - Choices: `NONE`, `DENY_IP`, `PERMIT_IP` - Default value: `NONE`
        """
        return pulumi.get(self, "default_rule")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationSgtId")
    def destination_sgt_id(self) -> pulumi.Output[builtins.str]:
        """
        Destination Trustsec Security Group ID
        """
        return pulumi.get(self, "destination_sgt_id")

    @property
    @pulumi.getter(name="matrixCellStatus")
    def matrix_cell_status(self) -> pulumi.Output[builtins.str]:
        """
        Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        """
        return pulumi.get(self, "matrix_cell_status")

    @property
    @pulumi.getter
    def sgacls(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of TrustSec Security Groups ACLs
        """
        return pulumi.get(self, "sgacls")

    @property
    @pulumi.getter(name="sourceSgtId")
    def source_sgt_id(self) -> pulumi.Output[builtins.str]:
        """
        Source Trustsec Security Group ID
        """
        return pulumi.get(self, "source_sgt_id")

