"""Data tools for AI agents.

This module provides data processing and manipulation tools organized into logical submodules:

- json_tools: JSON serialization, compression, and validation
- csv_tools: CSV file processing, parsing, and cleaning
- validation: Data validation and schema checking
- config_processing: Configuration file processing (YAML, TOML, INI)
"""

# Import all functions from submodules
from .config_processing import (
    count_config_items,
    filter_config_sections,
    get_config_keys,
    get_config_structure,
    get_config_value_at_path,
    merge_config_files,
    preview_config_section,
    read_ini_file,
    read_toml_file,
    read_yaml_file,
    search_config_keys,
    select_config_keys,
    validate_config_schema,
    write_ini_file,
    write_toml_file,
    write_yaml_file,
)
from .csv_tools import (
    clean_csv_data,
    count_csv_rows,
    csv_to_dict_list,
    detect_csv_delimiter,
    dict_list_to_csv,
    filter_csv_rows,
    get_csv_column_stats,
    get_csv_header,
    get_csv_info,
    get_csv_row_range,
    get_csv_schema,
    get_csv_value_counts,
    preview_csv_rows,
    read_csv_simple,
    sample_csv_rows,
    select_csv_columns,
    validate_csv_structure,
    write_csv_simple,
)
from .json_tools import (
    append_to_json_array,
    count_json_items,
    deduplicate_json_array,
    delete_json_key_at_path,
    filter_json_array,
    flatten_json_object,
    get_json_keys,
    get_json_structure,
    get_json_value_at_path,
    merge_json_objects,
    read_json_file,
    safe_json_deserialize,
    safe_json_serialize,
    search_json_keys,
    select_json_keys,
    slice_json_array,
    sort_json_array,
    transform_json_values,
    unflatten_json_object,
    update_json_value_at_path,
    validate_json_string,
    write_json_file,
)
from .validation import (
    check_required_fields,
    create_validation_report,
    validate_data_types_simple,
    validate_range_simple,
    validate_schema_simple,
)

# Re-export all functions at module level for convenience
__all__: list[str] = [
    # JSON processing (22 functions - 13 reading + 9 modification)
    "safe_json_serialize",
    "safe_json_deserialize",
    "validate_json_string",
    "read_json_file",
    "write_json_file",
    "get_json_value_at_path",
    "get_json_keys",
    "filter_json_array",
    "select_json_keys",
    "slice_json_array",
    "get_json_structure",
    "count_json_items",
    "search_json_keys",
    # JSON modification tools
    "update_json_value_at_path",
    "delete_json_key_at_path",
    "append_to_json_array",
    "merge_json_objects",
    "sort_json_array",
    "flatten_json_object",
    "unflatten_json_object",
    "transform_json_values",
    "deduplicate_json_array",
    # CSV processing
    "read_csv_simple",
    "write_csv_simple",
    "csv_to_dict_list",
    "dict_list_to_csv",
    "detect_csv_delimiter",
    "validate_csv_structure",
    "clean_csv_data",
    "get_csv_header",
    "preview_csv_rows",
    "get_csv_schema",
    "get_csv_info",
    "select_csv_columns",
    "filter_csv_rows",
    "get_csv_column_stats",
    "sample_csv_rows",
    "get_csv_row_range",
    "count_csv_rows",
    "get_csv_value_counts",
    # Validation
    "validate_schema_simple",
    "check_required_fields",
    "validate_data_types_simple",
    "validate_range_simple",
    "create_validation_report",
    # Configuration processing (16 functions - 8 read/write + 8 token-saving)
    "read_yaml_file",
    "write_yaml_file",
    "read_toml_file",
    "write_toml_file",
    "read_ini_file",
    "write_ini_file",
    "validate_config_schema",
    "merge_config_files",
    # Config token-saving inspection tools
    "get_config_keys",
    "get_config_value_at_path",
    "get_config_structure",
    "search_config_keys",
    "count_config_items",
    "select_config_keys",
    "filter_config_sections",
    "preview_config_section",
]
