/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of custom role IDs to use as access limits for the access token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#custom_roles AccessToken#custom_roles}
    */
    readonly customRoles?: string[];
    /**
    * The default API version for this token. Defaults to the latest API version. A change in this field will force the destruction of the existing token in state and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#default_api_version AccessToken#default_api_version}
    */
    readonly defaultApiVersion?: number;
    /**
    * An expiration time for the current token secret, expressed as a Unix epoch time. Replace the computed token secret with a new value. The expired secret will no longer be able to authorize usage of the LaunchDarkly API. This field argument is **deprecated**. Please update your config to remove `expire` to maintain compatibility with future versions
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#expire AccessToken#expire}
    */
    readonly expire?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#id AccessToken#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A human-friendly name for the access token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#name AccessToken#name}
    */
    readonly name?: string;
    /**
    * A built-in LaunchDarkly role. Can be `reader`, `writer`, or `admin`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#role AccessToken#role}
    */
    readonly role?: string;
    /**
    * Whether the token will be a [service token](https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens). A change in this field will force the destruction of the existing token and the creation of a new one.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#service_token AccessToken#service_token}
    */
    readonly serviceToken?: boolean | cdktf.IResolvable;
    /**
    * inline_roles block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#inline_roles AccessToken#inline_roles}
    */
    readonly inlineRoles?: AccessTokenInlineRoles[] | cdktf.IResolvable;
    /**
    * policy_statements block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#policy_statements AccessToken#policy_statements}
    */
    readonly policyStatements?: AccessTokenPolicyStatements[] | cdktf.IResolvable;
}
export interface AccessTokenInlineRoles {
    /**
    * The list of action specifiers defining the actions to which the statement applies.
  Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#actions AccessToken#actions}
    */
    readonly actions?: string[];
    /**
    * Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#effect AccessToken#effect}
    */
    readonly effect: string;
    /**
    * The list of action specifiers defining the actions to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#not_actions AccessToken#not_actions}
    */
    readonly notActions?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#not_resources AccessToken#not_resources}
    */
    readonly notResources?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#resources AccessToken#resources}
    */
    readonly resources?: string[];
}
export declare function accessTokenInlineRolesToTerraform(struct?: AccessTokenInlineRoles | cdktf.IResolvable): any;
export declare class AccessTokenInlineRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessTokenInlineRoles | cdktf.IResolvable | undefined;
    set internalValue(value: AccessTokenInlineRoles | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _notActions?;
    get notActions(): string[];
    set notActions(value: string[]);
    resetNotActions(): void;
    get notActionsInput(): string[] | undefined;
    private _notResources?;
    get notResources(): string[];
    set notResources(value: string[]);
    resetNotResources(): void;
    get notResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
}
export declare class AccessTokenInlineRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessTokenInlineRoles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessTokenInlineRolesOutputReference;
}
export interface AccessTokenPolicyStatements {
    /**
    * The list of action specifiers defining the actions to which the statement applies.
  Either `actions` or `not_actions` must be specified. For a list of available actions read [Actions reference](https://docs.launchdarkly.com/home/account-security/custom-roles/actions#actions-reference).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#actions AccessToken#actions}
    */
    readonly actions?: string[];
    /**
    * Either `allow` or `deny`. This argument defines whether the statement allows or denies access to the named resources and actions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#effect AccessToken#effect}
    */
    readonly effect: string;
    /**
    * The list of action specifiers defining the actions to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#not_actions AccessToken#not_actions}
    */
    readonly notActions?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement does not apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#not_resources AccessToken#not_resources}
    */
    readonly notResources?: string[];
    /**
    * The list of resource specifiers defining the resources to which the statement applies.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token#resources AccessToken#resources}
    */
    readonly resources?: string[];
}
export declare function accessTokenPolicyStatementsToTerraform(struct?: AccessTokenPolicyStatements | cdktf.IResolvable): any;
export declare class AccessTokenPolicyStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AccessTokenPolicyStatements | cdktf.IResolvable | undefined;
    set internalValue(value: AccessTokenPolicyStatements | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    resetActions(): void;
    get actionsInput(): string[] | undefined;
    private _effect?;
    get effect(): string;
    set effect(value: string);
    get effectInput(): string | undefined;
    private _notActions?;
    get notActions(): string[];
    set notActions(value: string[]);
    resetNotActions(): void;
    get notActionsInput(): string[] | undefined;
    private _notResources?;
    get notResources(): string[];
    set notResources(value: string[]);
    resetNotResources(): void;
    get notResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
}
export declare class AccessTokenPolicyStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AccessTokenPolicyStatements[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AccessTokenPolicyStatementsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token launchdarkly_access_token}
*/
export declare class AccessToken extends cdktf.TerraformResource {
    static readonly tfResourceType = "launchdarkly_access_token";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/resources/access_token launchdarkly_access_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessTokenConfig = {}
    */
    constructor(scope: Construct, id: string, config?: AccessTokenConfig);
    private _customRoles?;
    get customRoles(): string[];
    set customRoles(value: string[]);
    resetCustomRoles(): void;
    get customRolesInput(): string[] | undefined;
    private _defaultApiVersion?;
    get defaultApiVersion(): number;
    set defaultApiVersion(value: number);
    resetDefaultApiVersion(): void;
    get defaultApiVersionInput(): number | undefined;
    private _expire?;
    get expire(): number;
    set expire(value: number);
    resetExpire(): void;
    get expireInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _serviceToken?;
    get serviceToken(): boolean | cdktf.IResolvable;
    set serviceToken(value: boolean | cdktf.IResolvable);
    resetServiceToken(): void;
    get serviceTokenInput(): boolean | cdktf.IResolvable | undefined;
    get token(): string;
    private _inlineRoles;
    get inlineRoles(): AccessTokenInlineRolesList;
    putInlineRoles(value: AccessTokenInlineRoles[] | cdktf.IResolvable): void;
    resetInlineRoles(): void;
    get inlineRolesInput(): cdktf.IResolvable | AccessTokenInlineRoles[] | undefined;
    private _policyStatements;
    get policyStatements(): AccessTokenPolicyStatementsList;
    putPolicyStatements(value: AccessTokenPolicyStatements[] | cdktf.IResolvable): void;
    resetPolicyStatements(): void;
    get policyStatementsInput(): cdktf.IResolvable | AccessTokenPolicyStatements[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
