/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklyRelayProxyConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Relay Proxy configuration's unique 24 character ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/relay_proxy_configuration#id DataLaunchdarklyRelayProxyConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
export interface DataLaunchdarklyRelayProxyConfigurationPolicy {
}
export declare function dataLaunchdarklyRelayProxyConfigurationPolicyToTerraform(struct?: DataLaunchdarklyRelayProxyConfigurationPolicy): any;
export declare class DataLaunchdarklyRelayProxyConfigurationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklyRelayProxyConfigurationPolicy | undefined;
    set internalValue(value: DataLaunchdarklyRelayProxyConfigurationPolicy | undefined);
    get actions(): string[];
    get effect(): string;
    get notActions(): string[];
    get notResources(): string[];
    get resources(): string[];
}
export declare class DataLaunchdarklyRelayProxyConfigurationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklyRelayProxyConfigurationPolicyOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/relay_proxy_configuration launchdarkly_relay_proxy_configuration}
*/
export declare class DataLaunchdarklyRelayProxyConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_relay_proxy_configuration";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/relay_proxy_configuration launchdarkly_relay_proxy_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklyRelayProxyConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklyRelayProxyConfigurationConfig);
    get displayKey(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get name(): string;
    private _policy;
    get policy(): DataLaunchdarklyRelayProxyConfigurationPolicyList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
