/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataLaunchdarklySegmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the segment's purpose
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#description DataLaunchdarklySegment#description}
    */
    readonly description?: string;
    /**
    * The segment's environment key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#env_key DataLaunchdarklySegment#env_key}
    */
    readonly envKey: string;
    /**
    * List of user keys excluded from the segment. To target on other context kinds, use the excluded_contexts block attribute
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#excluded DataLaunchdarklySegment#excluded}
    */
    readonly excluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#id DataLaunchdarklySegment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * List of user keys included in the segment. To target on other context kinds, use the included_contexts block attribute
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#included DataLaunchdarklySegment#included}
    */
    readonly included?: string[];
    /**
    * The unique key that references the segment.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#key DataLaunchdarklySegment#key}
    */
    readonly key: string;
    /**
    * The segment's project key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#project_key DataLaunchdarklySegment#project_key}
    */
    readonly projectKey: string;
    /**
    * excluded_contexts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#excluded_contexts DataLaunchdarklySegment#excluded_contexts}
    */
    readonly excludedContexts?: DataLaunchdarklySegmentExcludedContexts[] | cdktf.IResolvable;
    /**
    * included_contexts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#included_contexts DataLaunchdarklySegment#included_contexts}
    */
    readonly includedContexts?: DataLaunchdarklySegmentIncludedContexts[] | cdktf.IResolvable;
    /**
    * rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#rules DataLaunchdarklySegment#rules}
    */
    readonly rules?: DataLaunchdarklySegmentRules[] | cdktf.IResolvable;
}
export interface DataLaunchdarklySegmentExcludedContexts {
    /**
    * The context kind associated with this segment target. To target on user contexts, use the included and excluded attributes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#context_kind DataLaunchdarklySegment#context_kind}
    */
    readonly contextKind: string;
    /**
    * List of target object keys included in or excluded from the segment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#values DataLaunchdarklySegment#values}
    */
    readonly values: string[];
}
export declare function dataLaunchdarklySegmentExcludedContextsToTerraform(struct?: DataLaunchdarklySegmentExcludedContexts | cdktf.IResolvable): any;
export declare class DataLaunchdarklySegmentExcludedContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentExcludedContexts | cdktf.IResolvable | undefined;
    set internalValue(value: DataLaunchdarklySegmentExcludedContexts | cdktf.IResolvable | undefined);
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    get contextKindInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataLaunchdarklySegmentExcludedContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataLaunchdarklySegmentExcludedContexts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentExcludedContextsOutputReference;
}
export interface DataLaunchdarklySegmentIncludedContexts {
    /**
    * The context kind associated with this segment target. To target on user contexts, use the included and excluded attributes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#context_kind DataLaunchdarklySegment#context_kind}
    */
    readonly contextKind: string;
    /**
    * List of target object keys included in or excluded from the segment
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#values DataLaunchdarklySegment#values}
    */
    readonly values: string[];
}
export declare function dataLaunchdarklySegmentIncludedContextsToTerraform(struct?: DataLaunchdarklySegmentIncludedContexts | cdktf.IResolvable): any;
export declare class DataLaunchdarklySegmentIncludedContextsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentIncludedContexts | cdktf.IResolvable | undefined;
    set internalValue(value: DataLaunchdarklySegmentIncludedContexts | cdktf.IResolvable | undefined);
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    get contextKindInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataLaunchdarklySegmentIncludedContextsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataLaunchdarklySegmentIncludedContexts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentIncludedContextsOutputReference;
}
export interface DataLaunchdarklySegmentRulesClauses {
    /**
    * The user attribute to operate on
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#attribute DataLaunchdarklySegment#attribute}
    */
    readonly attribute: string;
    /**
    * The context kind associated with this rule clause. This argument is only valid if `rollout_weights` is also specified. If omitted, defaults to `user`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#context_kind DataLaunchdarklySegment#context_kind}
    */
    readonly contextKind?: string;
    /**
    * Whether to negate the rule clause.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#negate DataLaunchdarklySegment#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The operator associated with the rule clause. Available options are `in`, `endsWith`, `startsWith`, `matches`, `contains`, `lessThan`, `lessThanOrEqual`, `greaterThanOrEqual`, `before`, `after`, `segmentMatch`, `semVerEqual`, `semVerLessThan`, and `semVerGreaterThan`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#op DataLaunchdarklySegment#op}
    */
    readonly op: string;
    /**
    * The type for each of the clause's values. Available types are `boolean`, `string`, and `number`. If omitted, `value_type` defaults to `string`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#value_type DataLaunchdarklySegment#value_type}
    */
    readonly valueType?: string;
    /**
    * The list of values associated with the rule clause.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#values DataLaunchdarklySegment#values}
    */
    readonly values: string[];
}
export declare function dataLaunchdarklySegmentRulesClausesToTerraform(struct?: DataLaunchdarklySegmentRulesClauses | cdktf.IResolvable): any;
export declare class DataLaunchdarklySegmentRulesClausesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentRulesClauses | cdktf.IResolvable | undefined;
    set internalValue(value: DataLaunchdarklySegmentRulesClauses | cdktf.IResolvable | undefined);
    private _attribute?;
    get attribute(): string;
    set attribute(value: string);
    get attributeInput(): string | undefined;
    private _contextKind?;
    get contextKind(): string;
    set contextKind(value: string);
    resetContextKind(): void;
    get contextKindInput(): string | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _op?;
    get op(): string;
    set op(value: string);
    get opInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    resetValueType(): void;
    get valueTypeInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export declare class DataLaunchdarklySegmentRulesClausesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataLaunchdarklySegmentRulesClauses[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentRulesClausesOutputReference;
}
export interface DataLaunchdarklySegmentRules {
    /**
    * The attribute by which to group users together.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#bucket_by DataLaunchdarklySegment#bucket_by}
    */
    readonly bucketBy?: string;
    /**
    * The context kind associated with this segment rule. This argument is only valid if weight is also specified. If omitted, defaults to 'user'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#rollout_context_kind DataLaunchdarklySegment#rollout_context_kind}
    */
    readonly rolloutContextKind?: string;
    /**
    * The integer weight of the rule (between 1 and 100000).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#weight DataLaunchdarklySegment#weight}
    */
    readonly weight?: number;
    /**
    * clauses block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment#clauses DataLaunchdarklySegment#clauses}
    */
    readonly clauses?: DataLaunchdarklySegmentRulesClauses[] | cdktf.IResolvable;
}
export declare function dataLaunchdarklySegmentRulesToTerraform(struct?: DataLaunchdarklySegmentRules | cdktf.IResolvable): any;
export declare class DataLaunchdarklySegmentRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataLaunchdarklySegmentRules | cdktf.IResolvable | undefined;
    set internalValue(value: DataLaunchdarklySegmentRules | cdktf.IResolvable | undefined);
    private _bucketBy?;
    get bucketBy(): string;
    set bucketBy(value: string);
    resetBucketBy(): void;
    get bucketByInput(): string | undefined;
    private _rolloutContextKind?;
    get rolloutContextKind(): string;
    set rolloutContextKind(value: string);
    resetRolloutContextKind(): void;
    get rolloutContextKindInput(): string | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    resetWeight(): void;
    get weightInput(): number | undefined;
    private _clauses;
    get clauses(): DataLaunchdarklySegmentRulesClausesList;
    putClauses(value: DataLaunchdarklySegmentRulesClauses[] | cdktf.IResolvable): void;
    resetClauses(): void;
    get clausesInput(): cdktf.IResolvable | DataLaunchdarklySegmentRulesClauses[] | undefined;
}
export declare class DataLaunchdarklySegmentRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataLaunchdarklySegmentRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataLaunchdarklySegmentRulesOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment launchdarkly_segment}
*/
export declare class DataLaunchdarklySegment extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "launchdarkly_segment";
    /**
    * Create a new {@link https://registry.terraform.io/providers/launchdarkly/launchdarkly/2.15.1/docs/data-sources/segment launchdarkly_segment} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataLaunchdarklySegmentConfig
    */
    constructor(scope: Construct, id: string, config: DataLaunchdarklySegmentConfig);
    get creationDate(): number;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _envKey?;
    get envKey(): string;
    set envKey(value: string);
    get envKeyInput(): string | undefined;
    private _excluded?;
    get excluded(): string[];
    set excluded(value: string[]);
    resetExcluded(): void;
    get excludedInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _included?;
    get included(): string[];
    set included(value: string[]);
    resetIncluded(): void;
    get includedInput(): string[] | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    get name(): string;
    private _projectKey?;
    get projectKey(): string;
    set projectKey(value: string);
    get projectKeyInput(): string | undefined;
    get tags(): string[];
    private _excludedContexts;
    get excludedContexts(): DataLaunchdarklySegmentExcludedContextsList;
    putExcludedContexts(value: DataLaunchdarklySegmentExcludedContexts[] | cdktf.IResolvable): void;
    resetExcludedContexts(): void;
    get excludedContextsInput(): cdktf.IResolvable | DataLaunchdarklySegmentExcludedContexts[] | undefined;
    private _includedContexts;
    get includedContexts(): DataLaunchdarklySegmentIncludedContextsList;
    putIncludedContexts(value: DataLaunchdarklySegmentIncludedContexts[] | cdktf.IResolvable): void;
    resetIncludedContexts(): void;
    get includedContextsInput(): cdktf.IResolvable | DataLaunchdarklySegmentIncludedContexts[] | undefined;
    private _rules;
    get rules(): DataLaunchdarklySegmentRulesList;
    putRules(value: DataLaunchdarklySegmentRules[] | cdktf.IResolvable): void;
    resetRules(): void;
    get rulesInput(): cdktf.IResolvable | DataLaunchdarklySegmentRules[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
